/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Index;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.stats.paintlet.AbstractZScorePaintlet;
import adams.gui.visualization.stats.paintlet.ZScoreCircle;
import adams.gui.visualization.stats.zscore.AbstractZScoreOverlay;
import adams.gui.visualization.stats.zscore.Mean;
import adams.gui.visualization.stats.zscore.StdDev;
import adams.gui.visualization.stats.zscore.ZScore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;

public class ZScoreDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = -909689793225143043L;
    protected ZScore m_ZScore;
    protected AbstractZScoreOverlay[] m_Overlays;
    protected AbstractZScorePaintlet m_Paintlet;
    protected BaseRegExp m_Att;
    protected String m_AttIndex;
    protected boolean m_ShowOptions;

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public void defineOptions() {
        super.defineOptions();
        Mean mean = new Mean();
        StdDev twoStd = new StdDev();
        StdDev threeStd = new StdDev();
        twoStd.setColor(Color.ORANGE);
        threeStd.setColor(Color.RED);
        twoStd.setStandardDeviations(2.0);
        threeStd.setStandardDeviations(3.0);
        this.m_OptionManager.add("overlay", "overlays", (Object)new AbstractZScoreOverlay[]{mean, twoStd, threeStd});
        this.m_OptionManager.add("paintlet", "paintlet", (Object)new ZScoreCircle());
        this.m_OptionManager.add("attribute-name", "attributeName", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("attribute", "attribute", (Object)"1");
        this.m_OptionManager.add("show-options", "showOptions", (Object)false);
    }

    public void setAttributeName(BaseRegExp val) {
        this.m_Att = val;
        this.reset();
    }

    public BaseRegExp getAttributeName() {
        return this.m_Att;
    }

    public String attributeNameTipText() {
        return "Name of attribute to display, used if set,otherwise the index is used";
    }

    public void setShowOptions(boolean value) {
        this.m_ShowOptions = value;
        this.reset();
    }

    public boolean getShowOptions() {
        return this.m_ShowOptions;
    }

    public String showOptionsTipText() {
        return "If enabled, the options are shown in the display, allowing the user to modify the visual appearance.";
    }

    public void setAttribute(String val) {
        this.m_AttIndex = val;
        this.reset();
    }

    public String getAttribute() {
        return this.m_AttIndex;
    }

    public String attributeTipText() {
        return "Set the attribute to display using an index, used only if regular expression not set";
    }

    public void setOverlays(AbstractZScoreOverlay[] over) {
        this.m_Overlays = over;
        this.reset();
    }

    public AbstractZScoreOverlay[] getOverlays() {
        return this.m_Overlays;
    }

    public String overlaysTipText() {
        return "Add overlays to the z score plot";
    }

    public void setPaintlet(AbstractZScorePaintlet paintlet) {
        this.m_Paintlet = paintlet;
        this.reset();
    }

    public AbstractZScorePaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "Choose paintlet for plotting data";
    }

    protected int getDefaultWidth() {
        return 1200;
    }

    protected int getDefaultHeight() {
        return 500;
    }

    public boolean supportsClear() {
        return true;
    }

    public void clearPanel() {
        if (this.m_ZScore != null) {
            DefaultSpreadSheet temp = new DefaultSpreadSheet();
            this.m_ZScore.setData((SpreadSheet)temp);
        }
    }

    protected BasePanel newPanel() {
        this.m_ZScore = new ZScore();
        this.m_ZScore.setOptionsVisible(this.getShowOptions());
        return this.m_ZScore;
    }

    protected void display(Token token) {
        this.m_ZScore.setAttReg(this.m_Att);
        this.m_ZScore.setAttindex(new Index(this.m_AttIndex));
        this.m_ZScore.setData((SpreadSheet)token.getPayload());
        this.m_ZScore.setOverlays(this.m_Overlays);
        this.m_ZScore.setPaintlet(this.m_Paintlet);
        this.m_ZScore.reset();
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        String name = "ZScore Display (" + ((SpreadSheet)token.getPayload()).getName() + ")";
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(name){
            private static final long serialVersionUID = 3272038733338355773L;
            protected ZScore m_ZScore;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_ZScore = new ZScore();
                this.m_ZScore.setOptionsVisible(false);
                this.add((Component)((Object)this.m_ZScore), "Center");
            }

            public void display(Token token) {
                try {
                    this.m_ZScore.setAttReg(ZScoreDisplay.this.m_Att);
                    this.m_ZScore.setAttindex(new Index(ZScoreDisplay.this.m_AttIndex));
                    this.m_ZScore.setData((SpreadSheet)token.getPayload());
                    this.m_ZScore.setOverlays((AbstractZScoreOverlay[])OptionUtils.shallowCopy((Object[])ZScoreDisplay.this.m_Overlays));
                    this.m_ZScore.setPaintlet((AbstractZScorePaintlet)((Object)OptionUtils.shallowCopy((Object)((Object)ZScoreDisplay.this.m_Paintlet))));
                    this.m_ZScore.reset();
                }
                catch (Exception e) {
                    ZScoreDisplay.this.handleException("Failed to display token", e);
                }
            }

            public JComponent supplyComponent() {
                return this.m_ZScore;
            }

            public void clearPanel() {
                this.m_ZScore.setData(null);
            }

            public void cleanUp() {
                this.m_ZScore.setData(null);
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public String globalInfo() {
        return "Actor for displaying a z score plot";
    }
}

