/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.fourinone;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.fourinone.VersusFitOptions;
import adams.gui.visualization.stats.fourinone.VersusFitPanel;
import adams.gui.visualization.stats.paintlet.VsFitPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class VersusFit
extends PaintablePanel
implements PopupMenuCustomizer {
    private static final long serialVersionUID = 2542241196305925848L;
    protected SpreadSheet m_Data;
    protected VersusFitPanel m_Plot;
    protected VsFitPaintlet m_val;
    protected VersusFitOptions m_VsFitOptions;
    protected int m_Index;
    protected int m_PredInd;
    protected SpreadSheetFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new VersusFitPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.m_Plot.setPopupMenuCustomizer(this);
        this.add((Component)((Object)this.m_Plot), "Center");
        this.m_val = new VsFitPaintlet();
        this.m_val.setPanel(this);
    }

    public void setOptions(VersusFitOptions val) {
        this.m_VsFitOptions = val;
        this.m_VsFitOptions.getAxisX().configure((PlotPanel)this.m_Plot, Axis.BOTTOM);
        this.m_VsFitOptions.getAxisY().configure((PlotPanel)this.m_Plot, Axis.LEFT);
        this.removePaintlet((Paintlet)this.m_val);
        this.m_val = (VsFitPaintlet)this.m_VsFitOptions.getPaintlet().shallowCopy(true);
        this.m_val.setPanel(this);
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        if (this.m_Data != null) {
            this.m_val.setData(this.m_Data);
            this.m_val.setIndices(this.m_Index, this.m_PredInd);
            this.m_val.setRepaintOnChange(true);
            AxisPanel axisBottom = this.getPlot().getAxis(Axis.BOTTOM);
            AxisPanel axisLeft = this.getPlot().getAxis(Axis.LEFT);
            double[] predicted = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_PredInd);
            double[] residuals = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_Index);
            double minY = StatUtils.min((double[])residuals);
            double maxY = StatUtils.max((double[])residuals);
            double maxX = StatUtils.max((double[])predicted);
            double minX = StatUtils.min((double[])predicted);
            axisBottom.setMinimum(minX);
            axisBottom.setMaximum(maxX);
            axisLeft.setMinimum(minY);
            axisLeft.setMaximum(maxY);
        }
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null && this.m_Data != null;
    }

    public SpreadSheet getData() {
        return this.m_Data;
    }

    public void setData(SpreadSheet value) {
        this.m_Data = value;
    }

    public void setIndices(int res, int pred) {
        this.m_Index = res;
        this.m_PredInd = pred;
    }

    protected void save() {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
        if (!writer.write(this.m_Data, this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save data to file:\n" + this.m_FileChooser.getSelectedFile()));
        }
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        JMenuItem menuitem = new JMenuItem("Save data...", ImageManager.getEmptyIcon());
        menuitem.addActionListener(ae -> this.save());
        menu.add(menuitem);
    }
}

