/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotHitDetector;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import adams.gui.visualization.stats.paintlet.ScatterPlotCircleHitDetector;
import adams.gui.visualization.stats.paintlet.SizeBasedPaintlet;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;

public class ScatterPaintletMetaDataValue
extends AbstractScatterPlotPaintlet
implements SizeBasedPaintlet {
    private static final long serialVersionUID = -4535962737391965432L;
    protected String m_MetaDataKey;
    protected Font m_Font;
    protected Map<String, Dimension> m_DimensionsCache;

    public String globalInfo() {
        return "Paintlet for displaying points on the scatter point as circles.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("meta-data-key", "metaDataKey", (Object)"");
        this.m_OptionManager.add("font", "font", (Object)Fonts.getSansFont((int)14));
        this.m_OptionManager.add("size", "size", (Object)5, (Number)1, null);
    }

    public void memberChanged() {
        super.memberChanged();
        this.m_DimensionsCache = new HashMap<String, Dimension>();
    }

    public void setMetaDataKey(String value) {
        this.m_MetaDataKey = value;
        this.memberChanged();
    }

    public String getMetaDataKey() {
        return this.m_MetaDataKey;
    }

    public String metaDataKeyTipText() {
        return "The key of the meta-data value to paint.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the meta-data value.";
    }

    @Override
    public void setSize(int val) {
        this.m_Size = val;
        this.memberChanged();
    }

    @Override
    public int getSize() {
        return this.m_Size;
    }

    @Override
    public String sizeTipText() {
        return "The size of each data point.";
    }

    @Override
    public AbstractScatterPlotHitDetector newHitDetector() {
        return new ScatterPlotCircleHitDetector(this);
    }

    @Override
    protected void drawData(Graphics g) {
        super.drawData(g);
        if (this.m_XData == null || this.m_YData == null) {
            return;
        }
        SpreadSheetColumnIndex colIndex = new SpreadSheetColumnIndex(this.m_MetaDataKey);
        colIndex.setData((Object)this.m_Data);
        int col = colIndex.getIntIndex();
        g.setFont(this.m_Font);
        FontMetrics metrics = g.getFontMetrics(this.m_Font);
        int ascent = metrics.getAscent();
        Graphics2D g2d = (Graphics2D)g;
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)true);
        for (int i = 0; i < this.m_XData.length; ++i) {
            int posX = this.m_AxisBottom.valueToPos(this.m_XData[i]);
            int posY = this.m_AxisLeft.valueToPos(this.m_YData[i]);
            g2d.setColor(this.getActualColor(i, this.m_Color));
            if (col > -1 && this.m_Data.getRow(i).hasCell(col) && !this.m_Data.getRow(i).getCell(col).isMissing()) {
                Dimension size;
                String text = this.m_Data.getRow(i).getCell(col).getContent();
                if (!this.m_DimensionsCache.containsKey(text)) {
                    int width = metrics.stringWidth(text);
                    size = new Dimension(width, ascent);
                    this.m_DimensionsCache.put(text, size);
                } else {
                    size = this.m_DimensionsCache.get(text);
                }
                g.drawString(text, posX -= size.width / 2, posY += size.height / 2);
                continue;
            }
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            g2d.drawOval(posX - (int)(0.5 * (double)this.m_Size), posY - (int)(0.5 * (double)this.m_Size), this.m_Size, this.m_Size);
        }
    }
}

