/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.probabilityplot;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.paintlet.Normal;
import adams.gui.visualization.stats.probabilityplot.NormalPlotOptions;
import adams.gui.visualization.stats.probabilityplot.ProbabilityPlotPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class NormalPlot
extends PaintablePanel
implements PopupMenuCustomizer {
    private static final long serialVersionUID = 2806317665479264377L;
    protected SpreadSheet m_Data;
    protected ProbabilityPlotPanel m_Plot;
    protected Normal m_Val;
    protected NormalPlotOptions m_NormOptions;
    protected int m_Index;
    protected SpreadSheetFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        this.m_NormOptions = new NormalPlotOptions();
        this.m_Data = null;
        this.m_Index = 0;
        this.m_FileChooser = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new ProbabilityPlotPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.m_Plot.setPopupMenuCustomizer(this);
        this.add((Component)((Object)this.m_Plot), "Center");
        this.m_Val = new Normal();
        this.m_Val.setPanel(this);
    }

    public void setOptions(NormalPlotOptions val) {
        this.m_NormOptions = val;
        this.m_NormOptions.getAxisX().configure((PlotPanel)this.m_Plot, Axis.BOTTOM);
        this.m_NormOptions.getAxisY().configure((PlotPanel)this.m_Plot, Axis.LEFT);
        this.update();
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        if (this.m_Data != null) {
            this.m_Val.setLine(this.m_NormOptions.m_RegLine);
            this.m_Val.setIndex(this.m_Index);
            this.m_Val.setData(this.m_Data);
            this.m_Val.configureAxes();
            this.m_Val.calculateDimensions();
        }
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null && this.m_Data != null;
    }

    public void setData(SpreadSheet data) {
        this.m_Data = data;
        this.update();
    }

    public SpreadSheet getData() {
        return this.m_Data;
    }

    public void setIndex(int val) {
        this.m_Index = val;
        this.update();
    }

    public int getIndex() {
        return this.m_Index;
    }

    protected void save() {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
        if (!writer.write(this.m_Data, this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save data to file:\n" + this.m_FileChooser.getSelectedFile()));
        }
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        JMenuItem menuitem = new JMenuItem("Save data...", ImageManager.getEmptyIcon());
        menuitem.addActionListener(ae -> this.save());
        menu.add(menuitem);
    }
}

