/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.probabilityplot;

import adams.core.Index;
import adams.core.base.BaseRegExp;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.ParameterPanel;
import adams.gui.event.PaintListener;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.core.IndexHelper;
import adams.gui.visualization.stats.paintlet.AbstractProbabilityPaintlet;
import adams.gui.visualization.stats.paintlet.Normal;
import adams.gui.visualization.stats.probabilityplot.ProbabilityPlotPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ProbabilityPlot
extends PaintablePanel
implements PopupMenuCustomizer {
    private static final long serialVersionUID = 5997080502859878659L;
    protected SpreadSheet m_Data;
    protected ProbabilityPlotPanel m_Plot;
    protected GenericObjectEditorPanel m_PanelRegression;
    protected AbstractProbabilityPaintlet m_Paintlet;
    protected AbstractProbabilityPaintlet m_DefaultPaintlet;
    protected int m_IntIndex;
    protected boolean m_Line;
    protected ParameterPanel m_OptionPanel;
    protected BaseCheckBox m_CheckBoxLine;
    protected BaseCheckBox m_CheckBoxGrid;
    protected boolean m_Grid;
    protected JLabel m_LabelMean;
    protected JLabel m_LabelStd;
    protected BaseRegExp m_AttReg;
    protected Index m_Index;
    protected SpreadSheetFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        BaseSplitPane splitPane = new BaseSplitPane(0);
        splitPane.setOneTouchExpandable(true);
        this.add((Component)splitPane, "Center");
        this.m_OptionPanel = new ParameterPanel();
        this.m_CheckBoxLine = new BaseCheckBox();
        if (this.m_Paintlet != null) {
            this.m_CheckBoxLine.setEnabled(this.m_Paintlet.hasFitLine());
        }
        this.m_CheckBoxGrid = new BaseCheckBox();
        this.m_CheckBoxLine.setSelected(false);
        this.m_CheckBoxGrid.setSelected(false);
        this.m_DefaultPaintlet = this.m_Paintlet == null ? new Normal() : this.m_Paintlet;
        this.m_PanelRegression = new GenericObjectEditorPanel(AbstractProbabilityPaintlet.class, (Object)this.m_DefaultPaintlet, true);
        this.m_PanelRegression.addChangeListener(e -> {
            this.changeRegression();
            this.changeGrid();
        });
        this.m_CheckBoxGrid.addActionListener(arg0 -> {
            this.m_Grid = ((BaseCheckBox)arg0.getSource()).isSelected();
            this.changeGrid();
        });
        this.m_CheckBoxLine.addItemListener(arg0 -> {
            this.m_Line = ((BaseCheckBox)arg0.getSource()).isSelected();
            if (this.m_Paintlet.hasFitLine()) {
                this.changeLine();
            }
        });
        this.m_OptionPanel.addParameter("Regression", (Component)this.m_PanelRegression);
        this.m_OptionPanel.addParameter("display grid", (Component)this.m_CheckBoxGrid);
        this.m_OptionPanel.addParameter("display best fit line", (Component)this.m_CheckBoxLine);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_OptionPanel, "Center");
        splitPane.setTopComponent((Component)panel);
        this.m_Plot = new ProbabilityPlotPanel();
        this.m_Plot.getAxis(Axis.LEFT).setTickGenerator((TickGenerator)new FancyTickGenerator());
        this.m_Plot.getAxis(Axis.LEFT).setNthValueToShow(1);
        this.m_Plot.getAxis(Axis.LEFT).setNumberFormat("#.##");
        this.m_Plot.getAxis(Axis.BOTTOM).setTickGenerator((TickGenerator)new FancyTickGenerator());
        this.m_Plot.getAxis(Axis.BOTTOM).setNthValueToShow(2);
        this.m_Plot.getAxis(Axis.BOTTOM).setNumberFormat("#.##");
        this.m_Plot.addPaintListener((PaintListener)this);
        this.m_Plot.setPopupMenuCustomizer(this);
        JPanel panelKey = new JPanel();
        panelKey.setLayout(new BoxLayout(panelKey, 1));
        this.m_LabelMean = new JLabel("");
        this.m_LabelStd = new JLabel("");
        panelKey.add(this.m_LabelMean);
        panelKey.add(this.m_LabelStd);
        panelKey.setBackground(Color.WHITE);
        panelKey.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        panel2.add((Component)panelKey, "North");
        panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.m_Plot), "Center");
        panel.add((Component)panel2, "East");
        splitPane.setBottomComponent((Component)panel);
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        if (this.m_Data != null && this.m_AttReg != null && this.m_Index != null) {
            int temp = -1;
            if ((temp = IndexHelper.getIndex(this.m_AttReg, this.m_Index, this.m_Data, temp)) == -1) {
                temp = 0;
                System.err.println("changed to 0");
            }
            this.m_IntIndex = temp;
            DecimalFormat df = new DecimalFormat("#.##");
            this.m_LabelMean.setText("Mean: " + df.format(StatUtils.mean((double[])SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_IntIndex))));
            this.m_LabelStd.setText("Std dev: " + df.format(StatUtils.stddev((double[])SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_IntIndex), (boolean)false)));
            this.m_Paintlet.setIndex(this.m_IntIndex);
            this.m_Paintlet.setData(this.m_Data);
            this.m_Paintlet.configureAxes();
            this.m_Paintlet.calculateDimensions();
            this.m_CheckBoxLine.setEnabled(this.m_Paintlet.hasFitLine());
            if (this.m_Paintlet.hasFitLine()) {
                this.m_Paintlet.setLine(this.m_Line);
            }
        }
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null && this.m_Data != null;
    }

    public SpreadSheet getData() {
        return this.m_Data;
    }

    public void setData(SpreadSheet data) {
        this.m_Data = data;
        this.m_IntIndex = this.m_Data.getColumnCount() - 1;
        this.update();
    }

    protected void changeRegression() {
        this.removePaintlet((Paintlet)this.m_Paintlet);
        this.m_Paintlet = (AbstractProbabilityPaintlet)((Object)this.m_PanelRegression.getCurrent());
        this.m_Paintlet.setPanel(this);
        this.m_Paintlet.configureAxes();
        this.m_Paintlet.setIndex(this.m_IntIndex);
        this.m_Paintlet.setData(this.m_Data);
        this.m_CheckBoxLine.setEnabled(this.m_Paintlet.hasFitLine());
        if (this.m_Paintlet.hasFitLine()) {
            this.m_Paintlet.setLine(this.m_Line);
        }
        this.update();
    }

    public void setRegression(AbstractProbabilityPaintlet val) {
        this.m_PanelRegression.setCurrent((Object)val.shallowCopy());
        this.changeRegression();
    }

    protected void changeGrid() {
        this.m_Plot.setGridColor(Color.LIGHT_GRAY);
        this.m_Plot.getAxis(Axis.LEFT).setShowGridLines(this.m_Grid);
        this.m_Plot.getAxis(Axis.BOTTOM).setShowGridLines(this.m_Grid);
        this.m_Plot.repaint();
        this.m_Plot.revalidate();
        this.update();
    }

    protected void changeLine() {
        this.m_Paintlet.setLine(this.m_Line);
        this.update();
    }

    public void setGrid(boolean val) {
        this.m_Grid = val;
        this.m_CheckBoxGrid.setSelected(val);
        this.changeGrid();
    }

    public boolean getGrid() {
        return this.m_Grid;
    }

    public void setRegressionLine(boolean val) {
        this.m_Line = val;
        this.m_CheckBoxLine.setSelected(val);
        this.update();
    }

    public boolean getRegressionLine() {
        return this.m_Line;
    }

    public void setAttIndex(Index val) {
        this.m_Index = val;
        this.update();
    }

    public Index getAttIndex() {
        return this.m_Index;
    }

    public void setAttRegExp(BaseRegExp val) {
        this.m_AttReg = val;
        this.update();
    }

    public BaseRegExp getAttRegExp() {
        return this.m_AttReg;
    }

    protected void save() {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
        if (!writer.write(this.m_Data, this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save data to file:\n" + this.m_FileChooser.getSelectedFile()));
        }
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        JMenuItem menuitem = new JMenuItem("Save data...", ImageManager.getEmptyIcon());
        menuitem.addActionListener(ae -> this.save());
        menu.add(menuitem);
    }
}

