/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.zscore;

import adams.core.Index;
import adams.core.base.BaseRegExp;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.event.PaintListener;
import adams.gui.goe.GenericArrayEditorPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import adams.gui.visualization.stats.core.IndexHelper;
import adams.gui.visualization.stats.paintlet.AbstractZScorePaintlet;
import adams.gui.visualization.stats.paintlet.ZScoreCircle;
import adams.gui.visualization.stats.zscore.AbstractZScoreOverlay;
import adams.gui.visualization.stats.zscore.ZScoreHitDetector;
import adams.gui.visualization.stats.zscore.ZScorePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ZScore
extends PaintablePanel
implements TipTextCustomizer,
PopupMenuCustomizer {
    private static final long serialVersionUID = 1398942330181177958L;
    protected ZScorePanel m_Plot;
    protected SpreadSheet m_Data;
    protected AbstractZScorePaintlet m_Val;
    protected AbstractZScorePaintlet m_Def;
    protected AbstractZScoreOverlay[] m_Over;
    protected AbstractZScoreOverlay[] m_Default;
    protected int m_Index;
    protected DefaultComboBoxModel m_ComboBox;
    protected BaseComboBox m_Att;
    protected GenericObjectEditorPanel m_PanelPaintlet;
    protected GenericArrayEditorPanel m_PanelOverlay;
    protected JPanel m_Key;
    protected BaseRegExp m_AttReg;
    protected Index m_AttIndex;
    protected ZScoreHitDetector m_Detect;
    protected int m_NumDialogs;
    protected BaseSplitPane m_SplitPane;
    protected SpreadSheetFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        this.m_Index = 0;
        this.m_NumDialogs = 0;
        this.m_AttReg = new BaseRegExp();
        this.m_AttIndex = new Index();
        this.m_FileChooser = null;
    }

    public void setData(SpreadSheet data) {
        this.m_Data = data;
    }

    public SpreadSheet getData() {
        return this.m_Data;
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        if (this.m_Data != null) {
            for (int i = 0; i < this.m_Over.length; ++i) {
                if (this.m_Over[i].getPaintlet() == null) continue;
                this.m_Over[i].getPaintlet().parameters(this.m_Data, this.m_Index);
                if (this.m_Over[i].getPaintlet().getCalculated()) continue;
                this.m_Over[i].getPaintlet().calculate();
            }
        }
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null;
    }

    public void reset() {
        for (int i = 0; i < this.m_Data.getColumnCount(); ++i) {
            this.m_ComboBox.addElement(this.m_Data.getColumnName(i));
        }
        int temp = -1;
        if ((temp = IndexHelper.getIndex(this.m_AttReg, this.m_AttIndex, this.m_Data, temp)) == -1) {
            temp = 0;
            System.err.println("changed to 0");
        }
        if (this.m_Over == null) {
            this.m_Over = new AbstractZScoreOverlay[0];
        }
        this.m_Att.setSelectedIndex(this.m_Index);
        this.m_Val.setPanel(this);
        this.m_Val.setData(this.m_Data);
        this.change();
    }

    private void changeOverlay() {
        int i;
        this.removeOverlays();
        int len = ((AbstractZScoreOverlay[])this.m_PanelOverlay.getCurrent()).length;
        this.m_Over = new AbstractZScoreOverlay[len];
        for (i = 0; i < len; ++i) {
            this.m_Over[i] = ((AbstractZScoreOverlay[])this.m_PanelOverlay.getCurrent())[i].shallowCopy(true);
        }
        for (i = 0; i < this.m_Over.length; ++i) {
            AbstractZScoreOverlay temp = this.m_Over[i];
            temp.setData(this.m_Data);
            temp.setParent(this);
            temp.setUp();
        }
        this.changeKey();
        this.repaint();
    }

    public void removeOverlays() {
        if (this.m_Over != null) {
            for (int i = 0; i < this.m_Over.length; ++i) {
                if (this.m_Over[i].getPaintlet() == null) continue;
                this.removePaintlet((Paintlet)this.m_Over[i].getPaintlet());
            }
            this.m_Over = null;
        }
    }

    protected void changePaintlet() {
        this.removePaintlet((Paintlet)this.m_Val);
        this.m_Val = (AbstractZScorePaintlet)((Object)this.m_PanelPaintlet.getCurrent());
        this.m_Val.setPanel(this);
        this.m_Val.setIndex(this.m_Index);
        this.m_Val.setData(this.m_Data);
        this.change();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new ZScorePanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        ParameterPanel optionPanel = new ParameterPanel();
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setLeftComponent((Component)((Object)this.m_Plot));
        JPanel hold = new JPanel(new BorderLayout());
        hold.add((Component)optionPanel, "North");
        this.m_SplitPane.setRightComponent((Component)hold);
        this.m_SplitPane.setResizeWeight(1.0);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.add((Component)this.m_SplitPane, "Center");
        hold.setPreferredSize(new Dimension(500, 0));
        this.m_ComboBox = new DefaultComboBoxModel();
        this.m_Att = new BaseComboBox((ComboBoxModel)this.m_ComboBox);
        AttListener listen = new AttListener(this);
        this.m_Att.addItemListener((ItemListener)listen);
        if (this.m_Val == null) {
            this.m_Def = new ZScoreCircle();
            this.m_Val = new ZScoreCircle();
        } else {
            this.m_Def = this.m_Val;
        }
        this.m_PanelPaintlet = new GenericObjectEditorPanel(AbstractZScorePaintlet.class, (Object)this.m_Def, true);
        this.m_PanelPaintlet.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ZScore.this.changePaintlet();
            }
        });
        this.m_Default = new AbstractZScoreOverlay[0];
        this.m_PanelOverlay = new GenericArrayEditorPanel((Object)this.m_Default);
        this.changeOverlay();
        this.m_PanelOverlay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ZScore.this.changeOverlay();
            }
        });
        JPanel east = new JPanel(new BorderLayout());
        east.setPreferredSize(new Dimension(100, 50));
        JLabel title = new JLabel("key");
        title.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JPanel titleHolder = new JPanel();
        titleHolder.add(title);
        this.m_Key = new JPanel();
        this.m_Key.setBackground(Color.WHITE);
        this.m_Key.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_Key.setLayout(new BoxLayout(this.m_Key, 1));
        JPanel keyHold = new JPanel();
        this.m_Key.setPreferredSize(new Dimension(100, 200));
        keyHold.add(this.m_Key);
        JPanel south = new JPanel(new BorderLayout());
        south.add((Component)titleHolder, "North");
        south.add((Component)keyHold, "South");
        east.add((Component)south, "South");
        BaseCheckBox grid = new BaseCheckBox();
        grid.addItemListener((ItemListener)new gridListener());
        this.changeKey();
        optionPanel.addParameter("attribute", (Component)this.m_Att);
        optionPanel.addParameter("Paintlet", (Component)this.m_PanelPaintlet);
        optionPanel.addParameter("Overlays", (Component)this.m_PanelOverlay);
        optionPanel.addParameter("Add grid", (Component)grid);
        hold.add((Component)east, "Center");
        this.m_Detect = new ZScoreHitDetector(this);
        this.getPlot().setTipTextCustomizer((TipTextCustomizer)this);
        this.getPlot().setPopupMenuCustomizer((PopupMenuCustomizer)this);
    }

    private void changeKey() {
        if (this.m_Key != null) {
            this.m_Key.removeAll();
            int len = this.m_Over.length;
            for (int i = 0; i < len; ++i) {
                BaseButton temp = new BaseButton(this.m_Over[i].shortName());
                temp.setBorder(null);
                temp.setFocusPainted(false);
                temp.setMargin(new Insets(0, 0, 0, 0));
                temp.setContentAreaFilled(false);
                temp.setBorderPainted(false);
                temp.setOpaque(false);
                temp.setForeground(this.m_Over[i].getColor());
                this.m_Key.add((Component)temp);
                temp.addActionListener((ActionListener)new pushButton());
            }
            this.repaint();
            this.revalidate();
        }
    }

    public void change() {
        if (this.m_Data != null) {
            this.m_Plot.setData(this.m_Data);
            this.m_Plot.setIndex(this.m_Index);
            this.m_Plot.reset();
            this.m_Val.setIndex(this.m_Index);
            this.m_Val.setData(this.m_Data);
            this.update();
            this.validate();
            this.repaint();
        }
    }

    public int getIndex() {
        return this.m_Index;
    }

    public void setOverlays(AbstractZScoreOverlay[] val) {
        AbstractZScoreOverlay[] overlays = new AbstractZScoreOverlay[val.length];
        for (int i = 0; i < val.length; ++i) {
            overlays[i] = val[i].shallowCopy();
        }
        this.m_PanelOverlay.setCurrent((Object)overlays);
        this.changeOverlay();
    }

    public void setPaintlet(AbstractZScorePaintlet val) {
        this.m_PanelPaintlet.setCurrent((Object)val.shallowCopy());
        this.removePaintlet((Paintlet)this.m_Val);
        this.m_Val = val;
    }

    public void setAttReg(BaseRegExp val) {
        this.m_AttReg = val;
    }

    public void setAttindex(Index val) {
        this.m_AttIndex = val;
    }

    public String processTipText(PlotPanel panel, Point mouse, String tiptext) {
        Object result = "";
        MouseEvent event = new MouseEvent((Component)this.getPlot().getContent(), 503, new Date().getTime(), 0, (int)mouse.getX(), (int)mouse.getY(), 0, false);
        String hit = (String)this.m_Detect.detect(event);
        if (hit != null) {
            result = (String)result + hit;
        }
        return result;
    }

    protected void showData() {
        SpreadSheetDialog dialog = this.getParentDialog() != null ? new SpreadSheetDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(this.getParentFrame(), false);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("ZScore");
        dialog.setSpreadSheet(this.m_Data);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    protected void save() {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
        if (!writer.write(this.m_Data, this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save data to file:\n" + this.m_FileChooser.getSelectedFile()));
        }
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        menu.addSeparator();
        JMenuItem menuitem = new JMenuItem("Save data...", ImageManager.getIcon((String)"save.gif"));
        menuitem.addActionListener(ae -> this.save());
        menu.add(menuitem);
        menuitem = new JMenuItem("Show data...", ImageManager.getIcon((String)"spreadsheet.png"));
        menuitem.addActionListener(ae -> this.showData());
        menu.add(menuitem);
    }

    public void setOptionsVisible(boolean value) {
        this.m_SplitPane.setRightComponentHidden(!value);
    }

    public boolean getOptionsVisible() {
        return !this.m_SplitPane.isRightComponentHidden();
    }

    protected class AttListener
    implements ItemListener {
        ZScore m_parent;

        public AttListener(ZScore parent) {
            this.m_parent = parent;
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            SpreadSheet inst = this.m_parent.getData();
            if (arg0.getStateChange() == 1) {
                String chose = (String)arg0.getItem();
                for (int i = 0; i < inst.getColumnCount(); ++i) {
                    if (!inst.getColumnName(i).equals(chose)) continue;
                    ZScore.this.m_Index = i;
                    for (int t = 0; t < ZScore.this.m_Over.length; ++t) {
                        ZScore.this.m_Over[t].getPaintlet().setCalculated(false);
                    }
                    ZScore.this.change();
                    break;
                }
            }
        }
    }

    public class pushButton
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            Color newCol;
            BaseButton push = (BaseButton)arg0.getSource();
            int index = 0;
            for (int i = 0; i < ZScore.this.m_Over.length; ++i) {
                if (!ZScore.this.m_Over[i].shortName().equals(push.getText())) continue;
                index = i;
                break;
            }
            if ((newCol = JColorChooser.showDialog((Component)((Object)ZScore.this), "Choose overlay color", ZScore.this.m_Over[index].getColor())) != null) {
                AbstractZScoreOverlay[] temp = (AbstractZScoreOverlay[])ZScore.this.m_PanelOverlay.getCurrent();
                temp[index].setColor(newCol);
                ZScore.this.m_PanelOverlay.setCurrent((Object)temp);
                ZScore.this.m_Over[index].setColor(newCol);
                ZScore.this.changeKey();
            }
        }
    }

    public class gridListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            JCheckBox check = (JCheckBox)e.getSource();
            if (check.isSelected()) {
                ZScore.this.m_Plot.getLeft().setShowGridLines(true);
                ZScore.this.m_Plot.getBottom().setShowGridLines(true);
                ZScore.this.m_Plot.setGridColor(Color.LIGHT_GRAY);
            } else {
                ZScore.this.m_Plot.getLeft().setShowGridLines(false);
                ZScore.this.m_Plot.getBottom().setShowGridLines(false);
            }
            ZScore.this.m_Plot.repaint();
        }
    }
}

