/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.zscore;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.AbstractDistanceBasedHitDetector;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.zscore.ZScore;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;

public class ZScoreHitDetector
extends AbstractDistanceBasedHitDetector<double[], String> {
    private static final long serialVersionUID = -5768575571226254067L;
    protected ZScore m_Owner;

    public ZScoreHitDetector(ZScore owner) {
        this.m_Owner = owner;
    }

    public String globalInfo() {
        return "Hit detector for the zscore visualisation";
    }

    public ZScore getOwner() {
        return this.m_Owner;
    }

    protected double[] isHit(MouseEvent e) {
        double distance = 1000.0;
        int val = 0;
        AxisPanel bottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel left = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double x = e.getX();
        double y = e.getY();
        double[] data = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Owner.getData(), (int)this.m_Owner.getIndex());
        for (int i = 0; i < data.length; ++i) {
            double thisDistance = Math.sqrt(Math.pow(x - (double)bottom.valueToPos((double)i), 2.0) + Math.pow(y - (double)left.valueToPos(data[i]), 2.0));
            if (!(thisDistance < distance)) continue;
            distance = thisDistance;
            val = i;
        }
        if (distance < 7.0) {
            return new double[]{val, data[val]};
        }
        return null;
    }

    protected String processHit(MouseEvent e, double[] hit) {
        if (hit == null) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("#");
        return "data point:" + df.format(hit[0]) + ", value:" + hit[1];
    }
}

