/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Properties;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.db.LogEntry;
import adams.event.VariableChangeListener;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.webservice.WebServiceProvider;
import com.example.customerservice.flow.CustomerServiceWS;
import java.util.HashSet;

public class WSServer
extends AbstractStandalone
implements CallableActorUser {
    private static final long serialVersionUID = 7347507489169005088L;
    protected WebServiceProvider m_WebService;
    protected CallableActorReference m_Log;
    protected AbstractActor m_LogActor;
    protected CallableActorHelper m_Helper;

    public String globalInfo() {
        return "Runs a webservice.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("web-service", "webService", (Object)new CustomerServiceWS());
        this.m_OptionManager.add("log", "log", (Object)new CallableActorReference("unknown"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setWebService(WebServiceProvider value) {
        this.m_WebService = value;
        this.m_WebService.setOwner((AbstractActor)this);
        this.reset();
    }

    public WebServiceProvider getWebService() {
        return this.m_WebService;
    }

    public String webServiceTipText() {
        return "The webservice to provide.";
    }

    public void setLog(CallableActorReference value) {
        this.m_Log = value;
        this.reset();
    }

    public CallableActorReference getLog() {
        return this.m_Log;
    }

    public String logTipText() {
        return "The name of the callable log actor to use (logging disabled if actor not found).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"webService", this.m_WebService.getClass());
        result = result + " on ";
        result = this.m_WebService instanceof OptionHandler ? result + QuickInfoHelper.toString((OptionHandler)((OptionHandler)this.m_WebService), (String)"URL", (Object)this.m_WebService.getURL()) : result + this.m_WebService.getURL();
        result = result + " [logging to '";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"log", (Object)this.getLog());
        result = result + "']";
        return result;
    }

    protected AbstractActor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive((AbstractActor)this, this.getLog());
    }

    public boolean hasCallableActor() {
        return this.m_LogActor != null;
    }

    public AbstractActor getCallableActor() {
        return this.m_LogActor;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_LogActor = this.findCallableActor();
            if (this.m_LogActor == null) {
                String msg = "Couldn't find callable log actor '" + this.getLog() + "' - logging disabled!";
                this.getLogger().severe(msg);
            } else {
                Compatibility comp = new Compatibility();
                if (!comp.isCompatible(new Class[]{LogEntry.class}, ((InputConsumer)this.m_LogActor).accepts())) {
                    result = "Log actor '" + this.getLog() + "' must accept " + LogEntry.class.getName() + "!";
                }
                if (result == null) {
                    HashSet variables = this.findVariables(this.m_LogActor);
                    this.m_DetectedVariables.addAll(variables);
                    if (this.m_DetectedVariables.size() > 0) {
                        this.getVariables().addVariableChangeListener((VariableChangeListener)this);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String msg, String id) {
        if (id != null && id.trim().length() == 0) {
            id = null;
        }
        if (this.m_LogActor == null) {
            this.getLogger().severe("LOG: " + (id == null ? "" : id + " - ") + msg);
            return;
        }
        Properties props = new Properties();
        props.setProperty("Errors", msg);
        if (id != null) {
            props.setProperty("ID", id);
        }
        LogEntry log = new LogEntry();
        log.setType("WebService");
        log.setSource(this.getFullName());
        log.setStatus("New");
        log.setMessage(props);
        try {
            String result;
            AbstractActor abstractActor = this.m_LogActor;
            synchronized (abstractActor) {
                ((InputConsumer)this.m_LogActor).input(new Token((Object)log));
                result = this.m_LogActor.execute();
            }
            if (result != null) {
                this.getLogger().severe("Failed to log message:\n" + log + "\n" + result);
            }
        }
        catch (Exception e) {
            this.handleException("Failed to log message:\n" + log, e);
        }
    }

    protected String doExecute() {
        this.m_WebService.setOwner((AbstractActor)this);
        return this.m_WebService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapUp() {
        this.m_WebService.stop();
        if (this.m_LogActor != null) {
            AbstractActor abstractActor = this.m_LogActor;
            synchronized (abstractActor) {
                this.m_LogActor.wrapUp();
            }
        }
        super.wrapUp();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_WebService.cleanUp();
        if (this.m_LogActor != null) {
            this.m_LogActor.cleanUp();
            this.m_LogActor = null;
        }
    }
}

