/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.Utils;
import adams.core.net.ProxyHelper;
import java.net.Proxy;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

public class WebserviceUtils {
    public static void enableSchemaValidation(BindingProvider provider) {
        provider.getRequestContext().put("schema-validation-enabled", "true");
    }

    public static void disableSchemaValidation(BindingProvider provider) {
        provider.getRequestContext().put("schema-validation-enabled", "false");
    }

    public static void configureClient(Object servicePort, int connection, int receive) {
        Client client = ClientProxy.getClient((Object)servicePort);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy clPolicy = new HTTPClientPolicy();
        clPolicy.setConnectionTimeout((long)connection);
        clPolicy.setReceiveTimeout((long)receive);
        clPolicy.setAllowChunking(false);
        clPolicy.setAutoRedirect(false);
        clPolicy.setConnection(ConnectionType.KEEP_ALIVE);
        ProxyAuthorizationPolicy proxyPolicy = null;
        switch (ProxyHelper.getSingleton().getProxyType()) {
            case DIRECT: {
                break;
            }
            case HTTP: {
                clPolicy.setProxyServerType(ProxyServerType.HTTP);
                clPolicy.setProxyServer(ProxyHelper.getSingleton().getHost(Proxy.Type.HTTP));
                clPolicy.setProxyServerPort(ProxyHelper.getSingleton().getPort(Proxy.Type.HTTP));
                clPolicy.setNonProxyHosts(Utils.flatten((Object[])ProxyHelper.getSingleton().getNoProxy(Proxy.Type.HTTP), (String)"|"));
                if (!ProxyHelper.getSingleton().getAuthentication(Proxy.Type.HTTP)) break;
                proxyPolicy = new ProxyAuthorizationPolicy();
                proxyPolicy.setUserName(ProxyHelper.getSingleton().getUser(Proxy.Type.HTTP));
                proxyPolicy.setPassword(ProxyHelper.getSingleton().getPassword(Proxy.Type.HTTP).getValue());
                proxyPolicy.setAuthorizationType("Basic");
                break;
            }
            case SOCKS: {
                clPolicy.setProxyServerType(ProxyServerType.SOCKS);
                clPolicy.setProxyServer(ProxyHelper.getSingleton().getHost(Proxy.Type.SOCKS));
                clPolicy.setProxyServerPort(ProxyHelper.getSingleton().getPort(Proxy.Type.SOCKS));
                clPolicy.setNonProxyHosts(Utils.flatten((Object[])ProxyHelper.getSingleton().getNoProxy(Proxy.Type.SOCKS), (String)"|"));
                if (!ProxyHelper.getSingleton().getAuthentication(Proxy.Type.SOCKS)) break;
                proxyPolicy = new ProxyAuthorizationPolicy();
                proxyPolicy.setUserName(ProxyHelper.getSingleton().getUser(Proxy.Type.SOCKS));
                proxyPolicy.setPassword(ProxyHelper.getSingleton().getPassword(Proxy.Type.SOCKS).getValue());
                proxyPolicy.setAuthorizationType("Basic");
                break;
            }
            default: {
                System.err.println("Proxy type not supported by CXF clients: " + (Object)((Object)ProxyHelper.getSingleton().getProxyType()));
            }
        }
        http.setClient(clPolicy);
        if (proxyPolicy != null) {
            http.setProxyAuthorization(proxyPolicy);
        }
    }
}

