/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.option.AbstractOptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.webservice.WebServiceClientProducer;
import java.net.URL;

public abstract class AbstractWebServiceClientSource<O>
extends AbstractOptionHandler
implements WebServiceClientProducer<O> {
    private static final long serialVersionUID = 3420305488797791952L;
    protected AbstractActor m_Owner;
    protected int m_ConnectionTimeout;
    protected int m_ReceiveTimeout;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("connection-timeout", "connectionTimeout", (Object)300000, (Number)0, null);
        this.m_OptionManager.add("receive-timeout", "receiveTimeout", (Object)300000, (Number)0, null);
    }

    @Override
    public void setConnectionTimeout(int value) {
        this.m_ConnectionTimeout = value;
        this.reset();
    }

    @Override
    public int getConnectionTimeout() {
        return this.m_ConnectionTimeout;
    }

    public String connectionTimeoutTipText() {
        return "The connection timeout in msec, 0 is infinite.";
    }

    @Override
    public void setReceiveTimeout(int value) {
        this.m_ReceiveTimeout = value;
        this.reset();
    }

    @Override
    public int getReceiveTimeout() {
        return this.m_ReceiveTimeout;
    }

    public String receiveTimeoutTipText() {
        return "The timeout for receiving in msec, 0 is infinite.";
    }

    @Override
    public void setOwner(AbstractActor value) {
        this.m_Owner = value;
    }

    @Override
    public AbstractActor getOwner() {
        return this.m_Owner;
    }

    protected abstract URL getWsdlLocation();

    protected void preQuery() throws Exception {
        if (this.m_Owner == null) {
            throw new IllegalStateException("No owning actor set!");
        }
    }

    protected abstract void doQuery() throws Exception;

    protected void postQuery() throws Exception {
    }

    @Override
    public void query() throws Exception {
        this.preQuery();
        this.doQuery();
        this.postQuery();
    }

    public void cleanUp() {
    }
}

