/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.standalone.WSServer;
import adams.flow.webservice.WebServiceProvider;
import java.net.URL;
import java.util.logging.Level;

public abstract class AbstractWebServiceProvider
extends AbstractOptionHandler
implements WebServiceProvider {
    private static final long serialVersionUID = 5989094825183495544L;
    protected AbstractActor m_Owner;
    protected String m_URL;
    protected boolean m_Running;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)this.getDefaultURL());
    }

    @Override
    public void setOwner(AbstractActor value) {
        this.m_Owner = value;
    }

    @Override
    public AbstractActor getOwner() {
        return this.m_Owner;
    }

    public abstract String getDefaultURL();

    public void setURL(String value) {
        try {
            new URL(value);
            this.m_URL = value;
            this.reset();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Invalid URL: " + value, e);
        }
    }

    @Override
    public String getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL of the service.";
    }

    protected void check() {
    }

    public void log(String msg, String id) {
        if (this.m_Owner instanceof WSServer) {
            ((WSServer)this.m_Owner).log(msg, id);
        }
    }

    protected abstract void doStart() throws Exception;

    @Override
    public String start() {
        String result;
        try {
            this.check();
            this.doStart();
            result = null;
            this.m_Running = true;
        }
        catch (Exception e) {
            String msg = "Failed to start service: ";
            this.getLogger().log(Level.SEVERE, msg, e);
            result = msg + Utils.throwableToString((Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isRunning() {
        return this.m_Running;
    }

    protected abstract void doStop() throws Exception;

    @Override
    public String stop() {
        String result;
        try {
            this.doStop();
            result = null;
        }
        catch (Exception e) {
            String msg = "Failed to stop service: ";
            this.getLogger().log(Level.SEVERE, msg, e);
            result = msg + Utils.throwableToString((Throwable)e);
        }
        this.m_Running = false;
        return result;
    }
}

