/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingLevelHandler;
import adams.core.logging.LoggingSupporter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class BaseLoggingInInterceptor
extends AbstractPhaseInterceptor<Message>
implements LoggingSupporter,
LoggingLevelHandler {
    protected LoggingLevel m_LoggingLevel;
    protected transient Logger m_Logger;

    public BaseLoggingInInterceptor() {
        super("receive");
        this.initializeLogging();
    }

    protected void initializeLogging() {
        this.m_LoggingLevel = LoggingLevel.WARNING;
    }

    protected void configureLogger() {
        this.m_Logger = LoggingHelper.getLogger(((Object)((Object)this)).getClass());
        this.m_Logger.setLevel(this.m_LoggingLevel.getLevel());
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.configureLogger();
        }
        return this.m_Logger;
    }

    public void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.configureLogger();
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_LoggingLevel;
    }

    public boolean isLoggingEnabled() {
        return LoggingHelper.isAtLeast((Level)this.m_LoggingLevel.getLevel(), (Level)Level.CONFIG);
    }

    public void handleMessage(Message message) throws Fault {
        if (!this.isLoggingEnabled()) {
            return;
        }
        this.logging(this.getLogger(), message);
    }

    @MixedCopyright(copyright="Apache CXF", license=License.APACHE2, note="org.apache.cxf.interceptor.AbstractLoggingInterceptor#writePayload")
    protected void writePayload(StringBuilder builder, CachedOutputStream cos, String encoding, String contentType) throws Exception {
        if (contentType != null && contentType.indexOf("xml") >= 0 && contentType.toLowerCase().indexOf("multipart/related") < 0 && cos.size() > 0L) {
            Transformer serializer = XMLUtils.newTransformer((int)2);
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter swriter = new StringWriter();
            serializer.transform(new StreamSource(cos.getInputStream()), new StreamResult(swriter));
            builder.append(swriter.toString());
        } else if (StringUtils.isEmpty((String)encoding)) {
            cos.writeCacheTo(builder);
        } else {
            cos.writeCacheTo(builder, encoding);
        }
    }

    @MixedCopyright(copyright="Apache CXF", license=License.APACHE2, note="org.apache.cxf.interceptor.LoggingInInterceptor#logging")
    protected void logging(Logger logger, Message message) throws Fault {
        InputStream is;
        String uri;
        Object headers;
        String ct;
        String httpMethod;
        String encoding;
        if (message.containsKey((Object)LoggingMessage.ID_KEY)) {
            return;
        }
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        message.put((Object)LoggingMessage.ID_KEY, (Object)id);
        LoggingMessage buffer = new LoggingMessage("Inbound Message\n----------------------------", id);
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        if ((uri = (String)message.get((Object)"org.apache.cxf.request.url")) != null) {
            buffer.getAddress().append(uri);
            String query = (String)message.get((Object)Message.QUERY_STRING);
            if (query != null) {
                buffer.getAddress().append("?").append(query);
            }
        }
        if ((is = (InputStream)message.getContent(InputStream.class)) != null) {
            CachedOutputStream bos = new CachedOutputStream();
            try {
                InputStream bis = is instanceof DelegatingInputStream ? ((DelegatingInputStream)is).getInputStream() : is;
                IOUtils.copyAndCloseInput((InputStream)bis, (OutputStream)bos);
                bos.flush();
                bis = bos.getInputStream();
                if (is instanceof DelegatingInputStream) {
                    ((DelegatingInputStream)is).setInputStream(bis);
                } else {
                    message.setContent(InputStream.class, (Object)bis);
                }
                if (bos.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + bos.getTempFile().getAbsolutePath() + "\n");
                }
                this.writePayload(buffer.getPayload(), bos, encoding, ct);
                bos.close();
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        }
        Reader reader = (Reader)message.getContent(Reader.class);
        if (reader != null) {
            try {
                CachedWriter writer = new CachedWriter();
                IOUtils.copyAndCloseInput((Reader)reader, (Writer)writer);
                message.setContent(Reader.class, (Object)writer.getReader());
                if (writer.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + writer.getTempFile().getAbsolutePath() + "\n");
                }
                writer.writeCacheTo(buffer.getPayload());
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        }
        logger.log(this.getLoggingLevel().getLevel(), buffer.toString());
    }
}

