/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingLevelHandler;
import adams.core.logging.LoggingSupporter;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class BaseLoggingOutInterceptor
extends AbstractPhaseInterceptor<Message>
implements LoggingSupporter,
LoggingLevelHandler {
    protected static final String BINARY_CONTENT_MESSAGE = "--- Binary Content ---";
    protected static final String LOG_SETUP = BaseLoggingOutInterceptor.class.getName() + ".log-setup";
    protected LoggingLevel m_LoggingLevel;
    protected transient Logger m_Logger;

    public BaseLoggingOutInterceptor() {
        super("send");
        this.initializeLogging();
    }

    protected void initializeLogging() {
        this.m_LoggingLevel = LoggingLevel.WARNING;
    }

    protected void configureLogger() {
        this.m_Logger = LoggingHelper.getLogger(((Object)((Object)this)).getClass());
        this.m_Logger.setLevel(this.m_LoggingLevel.getLevel());
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.configureLogger();
        }
        return this.m_Logger;
    }

    public void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.configureLogger();
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_LoggingLevel;
    }

    public boolean isLoggingEnabled() {
        return LoggingHelper.isAtLeast((Level)this.m_LoggingLevel.getLevel(), (Level)Level.CONFIG);
    }

    public void handleMessage(Message message) throws Fault {
        boolean hasLogged;
        if (!this.isLoggingEnabled()) {
            return;
        }
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        Writer iowriter = (Writer)message.getContent(Writer.class);
        if (os == null && iowriter == null) {
            return;
        }
        Logger logger = this.getLogger();
        if (this.isLoggingEnabled() && !(hasLogged = message.containsKey((Object)LOG_SETUP))) {
            message.put((Object)LOG_SETUP, (Object)Boolean.TRUE);
            if (os != null) {
                CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
                message.setContent(OutputStream.class, (Object)newOut);
                newOut.registerCallback((CachedOutputStreamCallback)new LoggingCallback(logger, message, os));
            }
        }
    }

    @MixedCopyright(copyright="Apache CXF", license=License.APACHE2, note="org.apache.cxf.interceptor.LoggingOutInterceptor#setupBuffer")
    protected LoggingMessage setupBuffer(Message message) {
        Object headers;
        String ct;
        String address;
        String httpMethod;
        String encoding;
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        LoggingMessage buffer = new LoggingMessage("Outbound Message\n---------------------------", id);
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((address = (String)message.get((Object)Message.ENDPOINT_ADDRESS)) != null) {
            buffer.getAddress().append(address);
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        return buffer;
    }

    @MixedCopyright(copyright="Apache CXF", license=License.APACHE2, note="org.apache.cxf.interceptor.AbstractLoggingInterceptor#writePayload")
    protected void writePayload(StringBuilder builder, CachedOutputStream cos, String encoding, String contentType) throws Exception {
        if (contentType != null && contentType.indexOf("xml") >= 0 && contentType.toLowerCase().indexOf("multipart/related") < 0 && cos.size() > 0L) {
            Transformer serializer = XMLUtils.newTransformer((int)2);
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter swriter = new StringWriter();
            serializer.transform(new StreamSource(cos.getInputStream()), new StreamResult(swriter));
            builder.append(swriter.toString());
        } else if (StringUtils.isEmpty((String)encoding)) {
            cos.writeCacheTo(builder);
        } else {
            cos.writeCacheTo(builder, encoding);
        }
    }

    class LoggingCallback
    implements CachedOutputStreamCallback {
        private final Message message;
        private final OutputStream origStream;

        public LoggingCallback(Logger logger, Message msg, OutputStream os) {
            this.message = msg;
            this.origStream = os;
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            LoggingMessage buffer = BaseLoggingOutInterceptor.this.setupBuffer(this.message);
            String ct = (String)this.message.get((Object)"Content-Type");
            if (cos.getTempFile() != null) {
                buffer.getMessage().append("Outbound Message (saved to tmp file):\n");
                buffer.getMessage().append("Filename: " + cos.getTempFile().getAbsolutePath() + "\n");
            }
            try {
                String encoding = (String)this.message.get((Object)Message.ENCODING);
                BaseLoggingOutInterceptor.this.writePayload(buffer.getPayload(), cos, encoding, ct);
            }
            catch (Exception ex) {
                // empty catch block
            }
            BaseLoggingOutInterceptor.this.getLogger().log(BaseLoggingOutInterceptor.this.getLoggingLevel().getLevel(), buffer.toString());
            try {
                cos.lockOutputStream();
                cos.resetOut(null, false);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.message.setContent(OutputStream.class, (Object)this.origStream);
        }
    }
}

