/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.webservice.WebServiceClient;
import adams.flow.webservice.WebServiceClientConsumer;
import adams.flow.webservice.WebServiceClientProducer;

public abstract class AbstractWSClient
extends AbstractActor {
    private static final long serialVersionUID = -1226032219173406368L;
    protected WebServiceClient m_Client;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("client", "client", (Object)this.getDefaultClient());
    }

    protected abstract WebServiceClient getDefaultClient();

    protected abstract String checkClient(WebServiceClient var1);

    public void setClient(WebServiceClient value) {
        String msg = this.checkClient(value);
        if (msg == null) {
            this.m_Client = value;
            this.m_Client.setOwner(this);
            this.reset();
        } else {
            this.getLogger().severe("Failed to set client: " + msg);
        }
    }

    public WebServiceClient getClient() {
        return this.m_Client;
    }

    public String clientTipText() {
        return "The webservice client to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"client", (Object)this.m_Client);
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            Class[] classes;
            if (this.m_Client instanceof WebServiceClientConsumer) {
                Class[] classes2;
                if ((ActorUtils.isSink((Actor)this) || ActorUtils.isTransformer((Actor)this)) && ((classes2 = ((WebServiceClientConsumer)this.m_Client).accepts()) == null || classes2.length == 0)) {
                    result = "Client '" + this.m_Client.getClass().getName() + "' defines no input type?";
                }
            } else if (this.m_Client instanceof WebServiceClientProducer && (ActorUtils.isSource((Actor)this) || ActorUtils.isTransformer((Actor)this)) && ((classes = ((WebServiceClientProducer)this.m_Client).generates()) == null || classes.length == 0)) {
                result = "Client '" + this.m_Client.getClass().getName() + "' defines no output type?";
            }
        }
        if (result == null) {
            this.m_Client.setOwner(this);
        }
        return result;
    }

    protected String preQuery() {
        return null;
    }

    protected String doQuery() {
        String result;
        try {
            this.m_Client.query();
            result = null;
        }
        catch (Exception e) {
            result = this.handleException("Failed to query webservice: ", e);
        }
        return result;
    }

    protected String postQuery() {
        return null;
    }

    protected String query() {
        String result = this.preQuery();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("preQuery: " + result);
        }
        if (result == null) {
            result = this.doQuery();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("doQuery: " + result);
            }
        }
        if (result == null) {
            result = this.postQuery();
            if (this.isLoggingEnabled()) {
                this.getLogger().info("postQuery: " + result);
            }
        }
        return result;
    }

    public void cleanUp() {
        this.m_Client.cleanUp();
        super.cleanUp();
    }
}

