/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.Utils;
import adams.core.logging.LoggingLevelHandler;
import adams.core.net.ProxyHelper;
import adams.flow.core.Actor;
import adams.flow.webservice.interceptor.InterceptorWithActor;
import adams.flow.webservice.interceptor.incoming.AbstractInInterceptorGenerator;
import adams.flow.webservice.interceptor.incoming.NullGenerator;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptorGenerator;
import adams.flow.webservice.interceptor.outgoing.Null;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

public class WebserviceUtils {
    public static final String MIMETYPE_APPLICATION_OCTETSTREAM = "application/octet-stream";
    public static final String MIMETYPE_PLAIN_TEXT = "plain/text";

    public static void enableSchemaValidation(BindingProvider provider) {
        provider.getRequestContext().put("schema-validation-enabled", "true");
    }

    public static void disableSchemaValidation(BindingProvider provider) {
        provider.getRequestContext().put("schema-validation-enabled", "false");
    }

    public static void configureClient(Actor owner, Object servicePort, int connection, int receive, String url, AbstractInInterceptorGenerator inInterceptor, AbstractOutInterceptorGenerator outInterceptor) {
        Client client = ClientProxy.getClient((Object)servicePort);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy clPolicy = new HTTPClientPolicy();
        clPolicy.setConnectionTimeout((long)connection);
        clPolicy.setReceiveTimeout((long)receive);
        clPolicy.setAllowChunking(false);
        clPolicy.setAutoRedirect(false);
        clPolicy.setConnection(ConnectionType.KEEP_ALIVE);
        ProxyAuthorizationPolicy proxyPolicy = null;
        switch (ProxyHelper.getSingleton().getProxyType()) {
            case DIRECT: {
                break;
            }
            case HTTP: {
                clPolicy.setProxyServerType(ProxyServerType.HTTP);
                clPolicy.setProxyServer(ProxyHelper.getSingleton().getHost(Proxy.Type.HTTP));
                clPolicy.setProxyServerPort(ProxyHelper.getSingleton().getPort(Proxy.Type.HTTP));
                clPolicy.setNonProxyHosts(Utils.flatten((Object[])ProxyHelper.getSingleton().getNoProxy(Proxy.Type.HTTP), (String)"|"));
                if (!ProxyHelper.getSingleton().getAuthentication(Proxy.Type.HTTP)) break;
                proxyPolicy = new ProxyAuthorizationPolicy();
                proxyPolicy.setUserName(ProxyHelper.getSingleton().getUser(Proxy.Type.HTTP));
                proxyPolicy.setPassword(ProxyHelper.getSingleton().getPassword(Proxy.Type.HTTP).getValue());
                proxyPolicy.setAuthorizationType("Basic");
                break;
            }
            case SOCKS: {
                clPolicy.setProxyServerType(ProxyServerType.SOCKS);
                clPolicy.setProxyServer(ProxyHelper.getSingleton().getHost(Proxy.Type.SOCKS));
                clPolicy.setProxyServerPort(ProxyHelper.getSingleton().getPort(Proxy.Type.SOCKS));
                clPolicy.setNonProxyHosts(Utils.flatten((Object[])ProxyHelper.getSingleton().getNoProxy(Proxy.Type.SOCKS), (String)"|"));
                if (!ProxyHelper.getSingleton().getAuthentication(Proxy.Type.SOCKS)) break;
                proxyPolicy = new ProxyAuthorizationPolicy();
                proxyPolicy.setUserName(ProxyHelper.getSingleton().getUser(Proxy.Type.SOCKS));
                proxyPolicy.setPassword(ProxyHelper.getSingleton().getPassword(Proxy.Type.SOCKS).getValue());
                proxyPolicy.setAuthorizationType("Basic");
                break;
            }
            default: {
                throw new IllegalStateException("Proxy type not supported by CXF clients: " + (Object)((Object)ProxyHelper.getSingleton().getProxyType()));
            }
        }
        http.setClient(clPolicy);
        if (proxyPolicy != null) {
            http.setProxyAuthorization(proxyPolicy);
        }
        if (url != null) {
            BindingProvider bindingProvider = (BindingProvider)servicePort;
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        }
        Object in = null;
        if (inInterceptor != null && !(inInterceptor instanceof NullGenerator)) {
            in = inInterceptor.generate();
        }
        if (in instanceof InterceptorWithActor) {
            ((InterceptorWithActor)in).setActor(owner);
        }
        if (in != null) {
            client.getInInterceptors().add(in);
        }
        Object out = null;
        if (outInterceptor != null && !(outInterceptor instanceof adams.flow.webservice.interceptor.outgoing.NullGenerator)) {
            out = outInterceptor.generate();
        }
        if (out instanceof InterceptorWithActor) {
            ((InterceptorWithActor)out).setActor(owner);
        }
        if (out != null) {
            client.getOutInterceptors().add(out);
        }
    }

    public static void configureServiceInterceptors(Actor owner, EndpointImpl endpoint, AbstractInInterceptorGenerator inInterceptor, AbstractOutInterceptorGenerator outInterceptor) {
        Object in = inInterceptor.generate();
        Object out = outInterceptor.generate();
        if (owner.isLoggingEnabled()) {
            if (in instanceof LoggingLevelHandler) {
                ((LoggingLevelHandler)in).setLoggingLevel(owner.getLoggingLevel());
            }
            if (out instanceof LoggingLevelHandler) {
                ((LoggingLevelHandler)out).setLoggingLevel(owner.getLoggingLevel());
            }
        }
        if (in instanceof InterceptorWithActor) {
            ((InterceptorWithActor)in).setActor(owner);
        }
        if (out instanceof InterceptorWithActor) {
            ((InterceptorWithActor)out).setActor(owner);
        }
        if (!(in instanceof adams.flow.webservice.interceptor.incoming.Null)) {
            endpoint.getServer().getEndpoint().getInInterceptors().add(in);
        }
        if (!(out instanceof Null)) {
            endpoint.getServer().getEndpoint().getOutInterceptors().add(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadWsdl(URL location) {
        StringBuilder result = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(location.openStream()));
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load WSDL from " + location + ": ");
            e.printStackTrace();
            result = null;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static String wsdlToHtml(String wsdl) {
        if (wsdl == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean lineStart = true;
        for (int i = 0; i < wsdl.length(); ++i) {
            String conv;
            char c = wsdl.charAt(i);
            switch (c) {
                case '<': {
                    conv = "&lt;";
                    break;
                }
                case '>': {
                    conv = "&gt;";
                    break;
                }
                case '/': {
                    conv = "&#47;";
                    break;
                }
                case '&': {
                    conv = "&amp;";
                    break;
                }
                case '@': {
                    conv = "&#64;";
                    break;
                }
                default: {
                    conv = "" + c;
                }
            }
            switch (c) {
                case '\n': 
                case '\r': {
                    lineStart = true;
                    conv = "" + c;
                    break;
                }
                case ' ': {
                    if (lineStart) {
                        conv = "&nbsp;";
                        break;
                    }
                    conv = " ";
                    break;
                }
                default: {
                    lineStart = false;
                    conv = "" + c;
                }
            }
            result.append(conv);
        }
        return result.toString();
    }
}

