/*
 * Decompiled with CFR 0.152.
 */
package com.example.customerservice.flow;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.flow.core.Actor;
import adams.flow.webservice.AbstractWebServiceClientSink;
import adams.flow.webservice.WebserviceUtils;
import com.example.customerservice.Customer;
import com.example.customerservice.CustomerService;
import com.example.customerservice.CustomerServiceService;
import java.net.URL;

@MixedCopyright(author="Apache CXF", license=License.APACHE2, note="Code from 'WSDL first' example", url="http://cxf.apache.org/docs/sample-projects.html")
public class UpdateCustomer
extends AbstractWebServiceClientSink<String> {
    private static final long serialVersionUID = -5099626472532203256L;
    protected String m_CustomerName;
    protected String m_ProvidedCustomerName;

    public String globalInfo() {
        return "Updates customers.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("customer-name", "customerName", (Object)"Smith");
    }

    public void setCustomerName(String value) {
        this.m_CustomerName = value;
        this.reset();
    }

    public String getCustomerName() {
        return this.m_CustomerName;
    }

    public String customerNameTipText() {
        return "The customer name to update.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public void setRequestData(String value) {
        this.m_ProvidedCustomerName = value;
    }

    @Override
    public URL getWsdlLocation() {
        return this.getClass().getClassLoader().getResource("wsdl/customerservice/CustomerService.wsdl");
    }

    @Override
    public void doQuery() throws Exception {
        String name = this.m_ProvidedCustomerName == null ? this.m_CustomerName : this.m_ProvidedCustomerName;
        Customer customer = new Customer();
        customer.setName(name);
        CustomerServiceService customerServiceService = new CustomerServiceService(this.getWsdlLocation());
        CustomerService customerService = customerServiceService.getCustomerServicePort();
        WebserviceUtils.configureClient((Actor)this.m_Owner, customerService, this.m_ConnectionTimeout, this.m_ReceiveTimeout, this.getUseAlternativeURL() ? this.getAlternativeURL() : null, null, this.m_OutInterceptor);
        customerService.updateCustomer(customer);
        this.m_ProvidedCustomerName = null;
    }
}

