/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.interceptor.incoming;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.flow.webservice.interceptor.incoming.AbstractInInterceptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;

@MixedCopyright(license=License.APACHE2, author="greenbird Integration Technology, http://www.greenbird.com/", url="https://raw.githubusercontent.com/greenbird/xml-formatter-components/master/cxf/src/main/java/com/greenbird/xmlformatter/cxf/XMLLoggingInInterceptor.java", note="simplified code")
public class XMLLoggingInInterceptor
extends AbstractInInterceptor {
    private static final String LOCAL_NAME = "MessageID";
    private static final int PROPERTIES_SIZE = 128;
    protected Logger logger;

    public XMLLoggingInInterceptor() {
        this(LoggingHelper.getLogger(XMLLoggingInInterceptor.class));
    }

    public XMLLoggingInInterceptor(Logger logger) {
        super("receive");
        this.logger = logger;
    }

    public void handleMessage(Message message) throws Fault {
        StringBuilder buffer;
        InputStream in = (InputStream)message.getContent(InputStream.class);
        if (in == null) {
            return;
        }
        CachedOutputStream cache = new CachedOutputStream();
        try {
            InputStream origIn = in;
            IOUtils.copy((InputStream)in, (OutputStream)cache);
            in = cache.size() > 0L ? cache.getInputStream() : new ByteArrayInputStream(new byte[0]);
            message.setContent(InputStream.class, (Object)in);
            cache.close();
            origIn.close();
            int contentSize = (int)cache.size();
            buffer = new StringBuilder(contentSize + 128);
            cache.writeCacheTo(buffer, "UTF-8");
        }
        catch (IOException e) {
            throw new Fault((Throwable)e);
        }
        char[] chars = new char[buffer.length()];
        buffer.getChars(0, chars.length, chars, 0);
        this.logProperties(buffer, message);
        this.logger.log(Level.INFO, buffer.toString());
    }

    protected String getIdHeader(Message message) {
        return this.getHeader(message, LOCAL_NAME);
    }

    protected String getHeader(Message message, String name) {
        List headers = (List)message.get((Object)Header.HEADER_LIST);
        if (headers != null) {
            for (Header header : headers) {
                if (!header.getName().getLocalPart().equalsIgnoreCase(name)) continue;
                return header.getObject().toString();
            }
        }
        return null;
    }

    protected void logProperties(StringBuilder buffer, Message message) {
        String messageId = this.getIdHeader(message);
        if (messageId != null) {
            buffer.append(" MessageId=");
            buffer.append(messageId);
        }
    }
}

