/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.interceptor.outgoing;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.flow.webservice.interceptor.InterceptorHelper;
import java.io.OutputStream;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;

@MixedCopyright(copyright="Apache CXF", license=License.APACHE2, note="org.apache.cxf.interceptor.LoggingOutInterceptor#setupBuffer and org.apache.cxf.interceptor.AbstractLoggingInterceptor#writePayload and org.apache.cxf.interceptor.LoggingInInterceptor#logging")
public abstract class AbstractOutgoingCallback
implements CachedOutputStreamCallback {
    protected final Message m_Message;
    protected final OutputStream m_OrigStream;

    public AbstractOutgoingCallback(Message msg, OutputStream os) {
        this.m_Message = msg;
        this.m_OrigStream = os;
    }

    public void onFlush(CachedOutputStream cos) {
    }

    public void onClose(CachedOutputStream cos) {
        LoggingMessage buffer = InterceptorHelper.setupOutgoingBuffer(this.m_Message);
        String ct = (String)this.m_Message.get((Object)"Content-Type");
        if (cos.getTempFile() == null) {
            buffer.getMessage().append("Outbound Message:\n");
        } else {
            buffer.getMessage().append("Outbound Message (saved to tmp file):\n");
            buffer.getMessage().append("Filename: " + cos.getTempFile().getAbsolutePath() + "\n");
        }
        try {
            String encoding = (String)this.m_Message.get((Object)Message.ENCODING);
            InterceptorHelper.writeOutgoingPayload(buffer.getPayload(), this.m_Message, cos, encoding, ct);
        }
        catch (Exception ex) {
            System.err.println("Failed to write payload!");
            ex.printStackTrace();
        }
        try {
            cos.lockOutputStream();
            cos.resetOut(null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Message.setContent(OutputStream.class, (Object)this.m_OrigStream);
        this.write(buffer);
    }

    protected abstract void write(LoggingMessage var1);
}

