/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.interceptor.incoming;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.io.FileUtils;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.data.conversion.PrettyPrintXML;
import adams.flow.webservice.interceptor.incoming.AbstractInInterceptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;

@MixedCopyright(license=License.APACHE2, author="greenbird Integration Technology, http://www.greenbird.com/", url="https://raw.githubusercontent.com/greenbird/xml-formatter-components/master/cxf/src/main/java/com/greenbird/xmlformatter/cxf/XMLLoggingInInterceptor.java", note="simplified code")
public class XMLLoggingInInterceptor
extends AbstractInInterceptor {
    private static final String LOCAL_NAME = "MessageID";
    private static final int PROPERTIES_SIZE = 128;
    protected Logger logger;
    protected boolean prettyPrint;
    protected File outputFile;
    protected PrettyPrintXML convert;
    protected transient DateFormat formatter;

    public XMLLoggingInInterceptor() {
        this(LoggingHelper.getLogger(XMLLoggingInInterceptor.class), false, null);
    }

    public XMLLoggingInInterceptor(Logger logger, boolean prettyPrint, File outputFile) {
        super("receive");
        this.logger = logger;
        this.prettyPrint = prettyPrint;
        this.outputFile = outputFile;
    }

    protected StringBuilder[] splitMessage(StringBuilder msg) {
        ArrayList<StringBuilder> result = new ArrayList<StringBuilder>();
        result.add(msg);
        String[] lines = msg.toString().split("\r\n");
        StringBuilder header = new StringBuilder();
        StringBuilder message = new StringBuilder();
        StringBuilder footer = new StringBuilder();
        int part = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (part == 0) {
                header.append(lines[i]);
                header.append("\r\n");
            } else if (part == 1) {
                message.append(lines[i]);
                ++part;
            } else if (part == 2) {
                footer.append(lines[i]);
            }
            if (lines[i].trim().length() != 0) continue;
            ++part;
        }
        if (message.length() > 0) {
            result.clear();
            result.add(header);
            result.add(message);
            result.add(footer);
        }
        return result.toArray(new StringBuilder[result.size()]);
    }

    protected StringBuilder prettyPrint(StringBuilder buffer) {
        StringBuilder result;
        if (this.prettyPrint) {
            if (buffer.indexOf("Content-Type") != -1) {
                StringBuilder[] parts = this.splitMessage(buffer);
                if (parts.length == 3) {
                    result = new StringBuilder();
                    result.append(parts[0].toString());
                    result.append((CharSequence)this.prettyPrint(parts[1]));
                    result.append(parts[2].toString().trim());
                } else {
                    result = buffer;
                }
            } else {
                if (this.convert == null) {
                    this.convert = new PrettyPrintXML();
                }
                this.convert.setInput((Object)buffer.toString());
                String msg = this.convert.convert();
                result = msg == null ? new StringBuilder((String)this.convert.getOutput()) : buffer;
            }
        } else {
            result = buffer;
        }
        return result;
    }

    public void handleMessage(Message message) throws Fault {
        StringBuilder buffer;
        InputStream in = (InputStream)message.getContent(InputStream.class);
        if (in == null) {
            return;
        }
        CachedOutputStream cache = new CachedOutputStream();
        try {
            InputStream origIn = in;
            IOUtils.copy((InputStream)in, (OutputStream)cache);
            in = cache.size() > 0L ? cache.getInputStream() : new ByteArrayInputStream(new byte[0]);
            message.setContent(InputStream.class, (Object)in);
            cache.close();
            origIn.close();
            int contentSize = (int)cache.size();
            buffer = new StringBuilder(contentSize + 128);
            cache.writeCacheTo(buffer, "UTF-8");
        }
        catch (IOException e) {
            throw new Fault((Throwable)e);
        }
        char[] chars = new char[buffer.length()];
        buffer.getChars(0, chars.length, chars, 0);
        buffer = this.prettyPrint(buffer);
        this.logProperties(buffer, message);
        if (this.outputFile != null) {
            if (this.formatter == null) {
                this.formatter = DateUtils.getTimestampFormatterMsecs();
            }
            FileUtils.writeToFile((String)this.outputFile.getAbsolutePath(), (Object)("\n--- " + this.formatter.format(new Date()) + " ---\n"), (boolean)true);
            FileUtils.writeToFile((String)this.outputFile.getAbsolutePath(), (Object)buffer, (boolean)true);
        } else {
            this.logger.log(Level.INFO, buffer.toString());
        }
    }

    protected String getIdHeader(Message message) {
        return this.getHeader(message, LOCAL_NAME);
    }

    protected String getHeader(Message message, String name) {
        List headers = (List)message.get((Object)Header.HEADER_LIST);
        if (headers != null) {
            for (Header header : headers) {
                if (!header.getName().getLocalPart().equalsIgnoreCase(name)) continue;
                return header.getObject().toString();
            }
        }
        return null;
    }

    protected void logProperties(StringBuilder buffer, Message message) {
        String messageId = this.getIdHeader(message);
        if (messageId != null) {
            buffer.append(" MessageId=");
            buffer.append(messageId);
        }
    }
}

