/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.webservice.AlternativeUrlSupporter;
import adams.flow.webservice.WebServiceClientConsumer;
import adams.flow.webservice.WebserviceUtils;
import adams.flow.webservice.WsdlUrlProvider;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptorGenerator;
import adams.flow.webservice.interceptor.outgoing.NullGenerator;
import java.net.URL;
import java.util.logging.Level;

public abstract class AbstractWebServiceClientSink<I>
extends AbstractOptionHandler
implements WebServiceClientConsumer<I>,
QuickInfoSupporter,
WsdlUrlProvider,
AlternativeUrlSupporter {
    private static final long serialVersionUID = 3420305488797791952L;
    protected Actor m_Owner;
    protected int m_ConnectionTimeout;
    protected int m_ReceiveTimeout;
    protected boolean m_UseAlternativeURL;
    protected String m_AlternativeURL;
    protected AbstractOutInterceptorGenerator m_OutInterceptor;
    protected String m_LastError;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("connection-timeout", "connectionTimeout", (Object)300000, (Number)0, null);
        this.m_OptionManager.add("receive-timeout", "receiveTimeout", (Object)300000, (Number)0, null);
        this.m_OptionManager.add("use-alternative-url", "useAlternativeURL", (Object)false);
        this.m_OptionManager.add("alternative-url", "alternativeURL", (Object)this.getDefaultAlternativeURL());
        this.m_OptionManager.add("out-interceptor", "outInterceptor", (Object)this.getDefaultOutInterceptor());
    }

    @Override
    public void setConnectionTimeout(int value) {
        this.m_ConnectionTimeout = value;
        this.reset();
    }

    @Override
    public int getConnectionTimeout() {
        return this.m_ConnectionTimeout;
    }

    public String connectionTimeoutTipText() {
        return "The connection timeout in msec, 0 is infinite.";
    }

    @Override
    public void setReceiveTimeout(int value) {
        this.m_ReceiveTimeout = value;
        this.reset();
    }

    @Override
    public int getReceiveTimeout() {
        return this.m_ReceiveTimeout;
    }

    public String receiveTimeoutTipText() {
        return "The timeout for receiving in msec, 0 is infinite.";
    }

    @Override
    public void setUseAlternativeURL(boolean value) {
        this.m_UseAlternativeURL = value;
        this.reset();
    }

    @Override
    public boolean getUseAlternativeURL() {
        return this.m_UseAlternativeURL;
    }

    @Override
    public String useAlternativeURLTipText() {
        return "If enabled, the specified alternative URL is used.";
    }

    @Override
    public String getDefaultAlternativeURL() {
        return "http://localhost:8080/";
    }

    @Override
    public void setAlternativeURL(String value) {
        if (value != null && !value.isEmpty()) {
            try {
                new URL(value);
                this.m_AlternativeURL = value;
                this.reset();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Invalid URL: " + value, (Throwable)e);
            }
        }
    }

    @Override
    public String getAlternativeURL() {
        return this.m_AlternativeURL;
    }

    @Override
    public String alternativeURLTipText() {
        return "The URL of the service.";
    }

    protected AbstractOutInterceptorGenerator getDefaultOutInterceptor() {
        return new NullGenerator();
    }

    @Override
    public void setOutInterceptor(AbstractOutInterceptorGenerator value) {
        this.m_OutInterceptor = value;
        this.reset();
    }

    @Override
    public AbstractOutInterceptorGenerator getOutInterceptor() {
        return this.m_OutInterceptor;
    }

    public String outInterceptorTipText() {
        return "The interceptor to use for outgoing messages.";
    }

    public String getAdditionalInformation() {
        StringBuilder result = new StringBuilder("WSDL: " + this.getWsdlLocation());
        String wsdl = WebserviceUtils.loadWsdl(this.getWsdlLocation());
        if (wsdl != null) {
            result.append("\n\n");
            result.append(WebserviceUtils.wsdlToHtml(wsdl));
        }
        return result.toString();
    }

    public String getQuickInfo() {
        String result = null;
        if (this.m_UseAlternativeURL || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useAlternativeURL")) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"alternativeURL", (Object)this.m_AlternativeURL);
        }
        return result;
    }

    @Override
    public void setOwner(Actor value) {
        this.m_Owner = value;
    }

    @Override
    public Actor getOwner() {
        return this.m_Owner;
    }

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    @Override
    public abstract URL getWsdlLocation();

    protected void preQuery() throws Exception {
        if (this.m_Owner == null) {
            throw new IllegalStateException("No owning actor set!");
        }
        this.m_LastError = null;
    }

    protected abstract void doQuery() throws Exception;

    protected void postQuery() throws Exception {
    }

    @Override
    public void query() throws Exception {
        this.preQuery();
        this.doQuery();
        this.postQuery();
    }

    public void cleanUp() {
        this.m_OutInterceptor.cleanUp();
    }
}

