/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.interceptor.incoming;

import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.io.PrettyPrintingSupporter;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.flow.webservice.interceptor.incoming.AbstractInInterceptorGenerator;
import adams.flow.webservice.interceptor.incoming.XMLLoggingInInterceptor;
import java.io.File;

public class XMLLoggingGenerator
extends AbstractInInterceptorGenerator<XMLLoggingInInterceptor>
implements PrettyPrintingSupporter,
FileWriter {
    private static final long serialVersionUID = -8109018608359183466L;
    protected boolean m_PrettyPrinting;
    protected PlaceholderFile m_OutputFile;

    public String globalInfo() {
        return "Generates a " + XMLLoggingInInterceptor.class.getName() + " instance.\nLogs the messages using its logger instance in XML or to a file, if supplied.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
        this.m_OptionManager.add("output-file", "outputFile", (Object)new PlaceholderFile());
    }

    protected LoggingLevel getDefaultLoggingLevel() {
        return LoggingLevel.INFO;
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, XML is output is 'pretty printed' format, i.e., nicely nested.";
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "Optional file to store the XML messages in; ignored if pointing to a directory, otherwise turns off logging in console.";
    }

    @Override
    protected XMLLoggingInInterceptor doGenerate() {
        Logger logger = LoggingHelper.getLogger(XMLLoggingInInterceptor.class);
        logger.setLevel(this.getLoggingLevel().getLevel());
        return new XMLLoggingInInterceptor(logger, this.m_PrettyPrinting, (File)(this.m_OutputFile.isDirectory() ? null : this.m_OutputFile));
    }
}

