/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.interceptor.outgoing;

import adams.flow.webservice.interceptor.InterceptorHelper;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptor;
import adams.flow.webservice.interceptor.outgoing.OutgoingLoggingCallback;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;

public class BaseLogging
extends AbstractOutInterceptor {
    public BaseLogging() {
        super("send");
    }

    public void handleMessage(Message message) throws Fault {
        if (!this.isLoggingEnabled()) {
            return;
        }
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        Writer iowriter = (Writer)message.getContent(Writer.class);
        if (os == null && iowriter == null) {
            return;
        }
        boolean hasLogged = message.containsKey((Object)InterceptorHelper.OUTGOING_LOG_SETUP);
        if (!hasLogged) {
            message.put((Object)InterceptorHelper.OUTGOING_LOG_SETUP, (Object)Boolean.TRUE);
            if (os != null) {
                CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
                message.setContent(OutputStream.class, (Object)newOut);
                newOut.registerCallback((CachedOutputStreamCallback)new OutgoingLoggingCallback(this.getLogger(), message, os));
            }
        }
    }
}

