/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.webservice.AbstractWebServiceClientSource;
import adams.flow.webservice.CallableTransformerSupport;

public abstract class AbstractWebServiceClientSourceWithCallableTransformer<O>
extends AbstractWebServiceClientSource<O>
implements CallableTransformerSupport<O, O> {
    private static final long serialVersionUID = -3505197925715473652L;
    protected CallableActorReference m_Transformer;
    protected Actor m_ActualTransformer;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformer", (Object)new CallableActorReference());
    }

    @Override
    public void setTransformer(CallableActorReference value) {
        this.m_Transformer = value;
        this.reset();
    }

    @Override
    public CallableActorReference getTransformer() {
        return this.m_Transformer;
    }

    @Override
    public String transformerTipText() {
        return "The callable transformer to use for further processing the data.";
    }

    @Override
    protected void preQuery() throws Exception {
        super.preQuery();
        if (this.m_ActualTransformer == null) {
            CallableActorHelper helper = new CallableActorHelper();
            this.m_ActualTransformer = helper.findCallableActorRecursive(this.getOwner(), this.m_Transformer);
            if (this.m_ActualTransformer == null) {
                throw new IllegalStateException("Failed to locate callable transformer '" + this.m_Transformer + "'!");
            }
            if (!ActorUtils.isTransformer((Actor)this.m_ActualTransformer)) {
                throw new IllegalStateException("Callable actor '" + this.m_Transformer + "' is not a transformer!");
            }
        }
    }

    @Override
    public O applyTransformer(O data) throws Exception {
        ((InputConsumer)this.m_ActualTransformer).input(new Token(data));
        String msg = this.m_ActualTransformer.execute();
        if (msg != null) {
            throw new IllegalStateException("Failed to post-process response data: " + msg);
        }
        if (!((OutputProducer)this.m_ActualTransformer).hasPendingOutput()) {
            throw new IllegalStateException("Callable transformer did not produce any data!");
        }
        Object result = ((OutputProducer)this.m_ActualTransformer).output().getPayload();
        if (((OutputProducer)this.m_ActualTransformer).hasPendingOutput()) {
            throw new IllegalStateException("Callable transformer still has pending output!");
        }
        return (O)result;
    }
}

