/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.interceptor.outgoing;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.io.FileUtils;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.data.conversion.PrettyPrintXML;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptor;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;

@MixedCopyright(license=License.APACHE2, author="greenbird Integration Technology, http://www.greenbird.com/", url="https://raw.githubusercontent.com/greenbird/xml-formatter-components/master/cxf/src/main/java/com/greenbird/xmlformatter/cxf/XMLLoggingOutInterceptor.java", note="simplified code")
public class XMLLoggingOutInterceptor
extends AbstractOutInterceptor {
    private static final String LOCAL_NAME = "MessageID";
    private static final int PROPERTIES_SIZE = 128;
    protected Logger logger = null;
    protected boolean prettyPrint;
    protected File outputFile;
    protected PrettyPrintXML convert;
    protected transient DateFormat formatter;

    public XMLLoggingOutInterceptor() {
        this(LoggingHelper.getLogger(XMLLoggingOutInterceptor.class), false, null);
    }

    public XMLLoggingOutInterceptor(Logger logger, boolean prettyPrint, File outputFile) {
        super("pre-stream");
        this.addBefore(StaxOutInterceptor.class.getName());
        this.logger = logger;
        this.prettyPrint = prettyPrint;
        this.outputFile = outputFile;
    }

    protected StringBuilder prettyPrint(StringBuilder buffer) {
        StringBuilder result;
        if (this.prettyPrint) {
            if (this.convert == null) {
                this.convert = new PrettyPrintXML();
            }
            this.convert.setInput((Object)buffer.toString());
            String msg = this.convert.convert();
            result = msg == null ? new StringBuilder((String)this.convert.getOutput()) : buffer;
        } else {
            result = buffer;
        }
        return result;
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        if (os == null) {
            return;
        }
        CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
        message.setContent(OutputStream.class, (Object)newOut);
        int contentSize = -1;
        String contentSizeString = this.getHeader(message, "Content-Size");
        if (contentSizeString != null) {
            contentSize = Integer.parseInt(contentSizeString);
        }
        if (contentSize == -1) {
            contentSize = 8192;
        }
        StringBuilder buffer = new StringBuilder(contentSize + 128);
        this.logProperties(buffer, message);
        newOut.registerCallback((CachedOutputStreamCallback)new SimpleLoggingCallback(buffer));
    }

    protected void logProperties(StringBuilder buffer, Message message) {
        String messageId = this.getIdHeader(message);
        if (messageId != null) {
            buffer.append(" MessageId=");
            buffer.append(messageId);
        }
    }

    protected String getIdHeader(Message message) {
        return this.getHeader(message, LOCAL_NAME);
    }

    protected String getHeader(Message message, String name) {
        List headers = (List)message.get((Object)Header.HEADER_LIST);
        if (headers != null) {
            for (Header header : headers) {
                if (!header.getName().getLocalPart().equalsIgnoreCase(name)) continue;
                return header.getObject().toString();
            }
        }
        return null;
    }

    protected class SimpleLoggingCallback
    implements CachedOutputStreamCallback {
        private StringBuilder buffer;

        public SimpleLoggingCallback(StringBuilder buffer) {
            this.buffer = buffer;
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            int length = this.buffer.length();
            try {
                cos.writeCacheTo(this.buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            char[] chars = new char[this.buffer.length() - length];
            this.buffer.getChars(length, this.buffer.length(), chars, 0);
            this.buffer = XMLLoggingOutInterceptor.this.prettyPrint(this.buffer);
            if (XMLLoggingOutInterceptor.this.outputFile != null) {
                if (XMLLoggingOutInterceptor.this.formatter == null) {
                    XMLLoggingOutInterceptor.this.formatter = DateUtils.getTimestampFormatterMsecs();
                }
                FileUtils.writeToFile((String)XMLLoggingOutInterceptor.this.outputFile.getAbsolutePath(), (Object)("\n--- " + XMLLoggingOutInterceptor.this.formatter.format(new Date()) + " ---\n"), (boolean)true);
                FileUtils.writeToFile((String)XMLLoggingOutInterceptor.this.outputFile.getAbsolutePath(), (Object)this.buffer, (boolean)true);
            } else {
                XMLLoggingOutInterceptor.this.logger.log(Level.INFO, this.buffer.toString());
            }
        }
    }
}

