/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.interceptor.incoming;

import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.NullToken;
import adams.flow.core.QueueHelper;
import adams.flow.webservice.interceptor.InterceptorHelper;
import adams.flow.webservice.interceptor.InterceptorWithActor;
import adams.flow.webservice.interceptor.incoming.AbstractInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.message.Message;

public class Enqueue
extends AbstractInInterceptor
implements InterceptorWithActor {
    protected StorageName m_StorageName;
    protected boolean m_EnqueueMessage;
    protected Actor m_Actor;

    public Enqueue() {
        super("receive");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_StorageName = new StorageName("queue");
        this.m_EnqueueMessage = false;
        this.m_Actor = null;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public void setEnqueueMessage(boolean value) {
        this.m_EnqueueMessage = value;
    }

    public boolean getEnqueueMessage() {
        return this.m_EnqueueMessage;
    }

    @Override
    public void setActor(Actor value) {
        this.m_Actor = value;
    }

    @Override
    public Actor getActor() {
        return this.m_Actor;
    }

    public void handleMessage(Message message) throws Fault {
        Object obj;
        if (this.m_Actor == null) {
            return;
        }
        if (this.m_EnqueueMessage) {
            LoggingMessage buffer = InterceptorHelper.writeIncomingMessage(message);
            obj = "" + buffer;
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.m_StorageName + ": " + buffer);
            }
        } else {
            obj = new NullToken();
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.m_StorageName + ": null token");
            }
        }
        QueueHelper.enqueue((Actor)this.m_Actor, (StorageName)this.m_StorageName, (Object)obj);
    }
}

