/*
 * Decompiled with CFR 0.152.
 */
package com.example.customerservice.flow;

import adams.core.License;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.flow.webservice.AbstractWebServiceClientTransformer;
import adams.flow.webservice.WebserviceUtils;
import com.example.customerservice.Customer;
import com.example.customerservice.CustomerService;
import com.example.customerservice.CustomerServiceService;
import java.net.URL;
import java.util.List;
import javax.xml.ws.BindingProvider;

@MixedCopyright(author="Apache CXF", license=License.APACHE2, note="Code from 'WSDL first' example", url="http://cxf.apache.org/docs/sample-projects.html")
public class CustomersByName
extends AbstractWebServiceClientTransformer<String, String> {
    private static final long serialVersionUID = -5099626472532203256L;
    protected String m_CustomerName;
    protected String m_ProvidedCustomerName;
    protected transient CustomerServiceService m_Service;
    protected transient CustomerService m_Port;

    public String globalInfo() {
        return "Returns customer names.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("customer-name", "customerName", (Object)"Smith");
    }

    protected void reset() {
        super.reset();
        this.m_Service = null;
        this.m_Port = null;
    }

    public void setCustomerName(String value) {
        this.m_CustomerName = value;
        this.reset();
    }

    public String getCustomerName() {
        return this.m_CustomerName;
    }

    public String customerNameTipText() {
        return "The customer name to look up.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public void setRequestData(String value) {
        this.m_ProvidedCustomerName = value;
    }

    @Override
    public URL getWsdlLocation() {
        return this.getClass().getClassLoader().getResource("wsdl/customerservice/CustomerService.wsdl");
    }

    @Override
    protected void doQuery() throws Exception {
        String name = this.m_ProvidedCustomerName == null ? this.m_CustomerName : this.m_ProvidedCustomerName;
        if (this.m_Service == null) {
            this.m_Service = new CustomerServiceService(this.getWsdlLocation());
            this.m_Port = this.m_Service.getCustomerServicePort();
            WebserviceUtils.configureClient(this.m_Owner, this.m_Port, this.m_ConnectionTimeout, this.m_ReceiveTimeout, this.getUseAlternativeURL() ? this.getAlternativeURL() : null, this.m_InInterceptor, this.m_OutInterceptor);
            WebserviceUtils.enableSchemaValidation((BindingProvider)this.m_Port);
        }
        List<Customer> customers = this.m_Port.getCustomersByName(name);
        this.setResponseData(customers.get(0).getCustomerId() + ": " + customers.get(0).getName() + ", " + Utils.flatten(customers.get(0).getAddress(), (String)" "));
        this.m_ProvidedCustomerName = null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    public void cleanUp() {
        this.m_Service = null;
        this.m_Port = null;
        super.cleanUp();
    }
}

