/*
 * Decompiled with CFR 0.152.
 */
package com.example.customerservice.server;

import adams.core.License;
import adams.core.annotation.ThirdPartyCopyright;
import com.example.customerservice.Customer;
import com.example.customerservice.CustomerService;
import com.example.customerservice.CustomerType;
import com.example.customerservice.NoSuchCustomer;
import com.example.customerservice.NoSuchCustomerException;
import com.example.customerservice.flow.CustomerServiceWS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceContext;

@ThirdPartyCopyright(author="Apache CXF", license=License.APACHE2, note="'WSDL first' example", url="http://cxf.apache.org/docs/sample-projects.html")
public class CustomerServiceImpl
implements CustomerService {
    @Resource
    WebServiceContext wsContext;
    protected CustomerServiceWS m_Owner;

    public CustomerServiceImpl(CustomerServiceWS owner) {
        this.m_Owner = owner;
    }

    @Override
    public List<Customer> getCustomersByName(String name) throws NoSuchCustomerException {
        if ("None".equals(name)) {
            NoSuchCustomer noSuchCustomer = new NoSuchCustomer();
            noSuchCustomer.setCustomerName(name);
            this.m_Owner.log("Did not find any matching customer for name=" + name, name);
            return new ArrayList<Customer>();
        }
        ArrayList<Customer> customers = new ArrayList<Customer>();
        for (int c = 0; c < 3; ++c) {
            Customer cust = new Customer();
            cust.setCustomerId(c);
            cust.setName(name);
            cust.getAddress().add("Pine Street " + (200 + c));
            Date bDate = new GregorianCalendar(2009, 1, 1 + c).getTime();
            cust.setBirthDate(bDate);
            cust.setNumOrders(1);
            cust.setRevenue(10000.0);
            cust.setTest(new BigDecimal(1.5));
            cust.setType(CustomerType.BUSINESS);
            customers.add(cust);
        }
        return customers;
    }

    @Override
    public void updateCustomer(Customer customer) {
        this.m_Owner.log("update request was received", customer.getName());
        System.out.println("update request was received");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_Owner.log("Customer was updated", customer.getName());
    }
}

