/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.instance.Instance;
import adams.data.io.input.InstanceReader;
import adams.data.report.AbstractReportFilter;
import adams.data.report.AbstractReportFilterTestCase;
import adams.data.report.DataType;
import adams.data.report.RemoveByDataType;
import adams.env.Environment;
import adams.test.TmpFile;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class RemoveByDataTypeTest
extends AbstractReportFilterTestCase<AbstractReportFilter, Instance> {
    public RemoveByDataTypeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        super.tearDown();
    }

    protected Instance load(String filename) {
        InstanceReader reader = new InstanceReader();
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        List data = reader.read();
        reader.cleanUp();
        if (data.size() > 0) {
            return (Instance)data.get(0);
        }
        return null;
    }

    protected boolean save(Instance data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data.getReport(), (boolean)false);
    }

    protected String[] getRegressionInputFiles() {
        return new String[]{"bolts.arff", "bolts.arff", "bolts.arff"};
    }

    protected AbstractReportFilter[] getRegressionSetups() {
        RemoveByDataType[] result = new RemoveByDataType[3];
        result[0] = new RemoveByDataType();
        result[1] = new RemoveByDataType();
        result[1].setDataTypes(new DataType[]{DataType.NUMERIC});
        result[2] = new RemoveByDataType();
        result[2].setDataTypes(new DataType[]{DataType.NUMERIC});
        result[2].setInvertMatching(true);
        return result;
    }

    public static Test suite() {
        return new TestSuite(RemoveByDataTypeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        RemoveByDataTypeTest.runTest((Test)RemoveByDataTypeTest.suite());
    }
}

