/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.Conversion;
import adams.data.conversion.WekaInstanceToAdamsInstance;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.Convert;
import adams.flow.transformer.ReportField;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.flow.transformer.WekaInstanceBuffer;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveRange;

public class ReportFieldTest
extends AbstractFlowTest {
    public ReportFieldTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        WekaClassSelector cs = new WekaClassSelector();
        RemoveRange rr = new RemoveRange();
        rr.setInstancesIndices("2-last");
        WekaFilter wf = new WekaFilter();
        wf.setFilter((Filter)rr);
        WekaInstanceBuffer ib = new WekaInstanceBuffer();
        ib.setOperation(WekaInstanceBuffer.Operation.INSTANCES_TO_INSTANCE);
        Convert ci = new Convert();
        ci.setConversion((Conversion)new WekaInstanceToAdamsInstance());
        ReportField rf = new ReportField();
        rf.setRegExp(new BaseRegExp("(Class|.*ID)"));
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{sfs, fr, cs, wf, ib, ci, rf, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(ReportFieldTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ReportFieldTest.runTest((Test)ReportFieldTest.suite());
    }
}

