/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Tool;
import adams.test.TmpFile;
import adams.tools.AbstractTool;
import adams.tools.CompareDatasets;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ToolTest
extends AbstractFlowTest {
    public ToolTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff", "vote2.arff");
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-missing.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("vote2.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-missing.csv");
        super.tearDown();
    }

    public Actor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("dummy")});
        CompareDatasets comp = new CompareDatasets();
        comp.setDataset1((PlaceholderFile)new TmpFile("vote.arff"));
        comp.setDataset2((PlaceholderFile)new TmpFile("vote2.arff"));
        comp.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.csv"));
        comp.setMissing((PlaceholderFile)new TmpFile("dumpfile-missing.csv"));
        Tool tool = new Tool();
        tool.setTool((AbstractTool)comp);
        Flow flow = new Flow();
        flow.setActors(new Actor[]{sc, tool});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.csv"), new TmpFile("dumpfile-missing.csv")});
    }

    public static Test suite() {
        return new TestSuite(ToolTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ToolTest.runTest((Test)ToolTest.suite());
    }
}

