/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseInterval;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaEvaluationPostProcessor;
import adams.flow.transformer.WekaEvaluationSummary;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.wekaevaluationpostprocessor.AbstractWekaEvaluationPostProcessor;
import adams.flow.transformer.wekaevaluationpostprocessor.SubRange;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.classifiers.evaluation.output.prediction.Null;
import weka.classifiers.functions.LinearRegression;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.SimpleArffLoader;

public class WekaEvaluationPostProcessorTest
extends AbstractFlowTest {
    public WekaEvaluationPostProcessorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bodyfat.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bodyfat.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaEvaluationPostProcessorTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            CallableActors callableactors = new CallableActors();
            ArrayList<WekaClassifierSetup> actors2 = new ArrayList<WekaClassifierSetup>();
            WekaClassifierSetup wekaclassifiersetup = new WekaClassifierSetup();
            LinearRegression linearregression = new LinearRegression();
            linearregression.setOptions(OptionUtils.splitOptions((String)"-S 0 -R 1.0E-8 -num-decimal-places 4"));
            wekaclassifiersetup.setClassifier((Classifier)linearregression);
            actors2.add(wekaclassifiersetup);
            callableactors.setActors(actors2.toArray(new Actor[0]));
            actors.add(callableactors);
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/bodyfat.arff"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            WekaFileReader wekafilereader = new WekaFileReader();
            SimpleArffLoader simplearffloader = new SimpleArffLoader();
            wekafilereader.setCustomLoader((AbstractFileLoader)simplearffloader);
            actors.add(wekafilereader);
            WekaClassSelector wekaclassselector = new WekaClassSelector();
            actors.add(wekaclassselector);
            WekaCrossValidationEvaluator wekacrossvalidationevaluator = new WekaCrossValidationEvaluator();
            Null null_ = new Null();
            wekacrossvalidationevaluator.setOutput((AbstractOutput)null_);
            actors.add(wekacrossvalidationevaluator);
            WekaEvaluationPostProcessor wekaevaluationpostprocessor = new WekaEvaluationPostProcessor();
            SubRange subrange = new SubRange();
            subrange.setRanges(new BaseInterval[]{new BaseInterval("[10.0;20.0]")});
            wekaevaluationpostprocessor.setPostProcessor((AbstractWekaEvaluationPostProcessor)subrange);
            actors.add(wekaevaluationpostprocessor);
            WekaEvaluationSummary wekaevaluationsummary = new WekaEvaluationSummary();
            actors.add(wekaevaluationsummary);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            WekaEvaluationPostProcessorTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaEvaluationPostProcessorTest.runTest((Test)WekaEvaluationPostProcessorTest.suite());
    }
}

