/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka;

import adams.core.Range;
import adams.core.RangeTest;
import adams.data.weka.WekaLabelRange;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.FileNotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaLabelRangeTest
extends RangeTest {
    protected Instances m_Data;

    public WekaLabelRangeTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/weka/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "labor.arff";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Data = ConverterUtils.DataSource.read((String)new TmpFile(filename).getAbsolutePath());
        if (this.m_Data == null) {
            throw new FileNotFoundException("Test file '" + filename + "' not found?");
        }
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        super.tearDown();
    }

    protected Range newRange(String index, int max) {
        if (index == null) {
            return new WekaLabelRange();
        }
        return new WekaLabelRange(index, max);
    }

    public void testColumnNames() {
        WekaLabelRange range = new WekaLabelRange();
        range = new WekaLabelRange("first-last");
        WekaLabelRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"first-last", (String)range.getRange());
        range.setData(null);
        range.setRange("blah");
        WekaLabelRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"blah", (String)range.getRange());
        range.setData((Object)this.m_Data.attribute(this.m_Data.numAttributes() - 2));
        range.setRange("none");
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"none", (String)range.getRange());
        range.setData((Object)this.m_Data.attribute(this.m_Data.numAttributes() - 2));
        range.setRange("non");
        WekaLabelRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"non", (String)range.getRange());
        range.setData(null);
        range.setRange("half");
        WekaLabelRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"half", (String)range.getRange());
        range.setData((Object)this.m_Data.attribute(this.m_Data.numAttributes() - 2));
        range.setRange("half");
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"half", (String)range.getRange());
        range.setData((Object)this.m_Data.attribute(this.m_Data.numAttributes() - 2));
        range.setRange("\"half\"");
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"\"half\"", (String)range.getRange());
        range.setData((Object)this.m_Data.attribute(this.m_Data.numAttributes() - 2));
        range.setRange("none-half");
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices()[1]);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"none-half", (String)range.getRange());
        range.setData((Object)this.m_Data.attribute(this.m_Data.numAttributes() - 2));
        range.setRange("\"none\"-\"half\"");
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices()[1]);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"\"none\"-\"half\"", (String)range.getRange());
    }

    public void testSpecialLabelNames() {
        WekaLabelRange range = new WekaLabelRange();
        range.setData((Object)this.m_Data.attribute("pension"));
        range.setRange("\"ret_allw\"");
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices()[0]);
        WekaLabelRangeTest.assertEquals((String)"should be same", (String)"\"ret_allw\"", (String)range.getRange());
    }

    public void testSubstrings() {
        WekaLabelRange range = new WekaLabelRange();
        range.setRange("averaged");
        range.setData((Object)this.m_Data.attribute("vacation"));
        WekaLabelRangeTest.assertEquals((String)"shouldn't find any cols", (int)0, (int)range.getIntIndices().length);
        range = new WekaLabelRange();
        range.setRange("average");
        range.setData((Object)this.m_Data.attribute("vacation"));
        WekaLabelRangeTest.assertEquals((String)"# indices differs", (int)1, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"index differs", (int)1, (int)range.getIntIndices()[0]);
        range = new WekaLabelRange();
        range.setRange("\"average\"");
        range.setData((Object)this.m_Data.attribute("vacation"));
        WekaLabelRangeTest.assertEquals((String)"# indices differs", (int)1, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"index differs", (int)1, (int)range.getIntIndices()[0]);
        range = new WekaLabelRange();
        range.setRange("\"below_average\"");
        range.setData((Object)this.m_Data.attribute("vacation"));
        WekaLabelRangeTest.assertEquals((String)"# indices differs", (int)1, (int)range.getIntIndices().length);
        WekaLabelRangeTest.assertEquals((String)"index differs", (int)0, (int)range.getIntIndices()[0]);
    }

    public static Test suite() {
        return new TestSuite(WekaLabelRangeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaLabelRangeTest.runTest((Test)WekaLabelRangeTest.suite());
    }
}

