/*
 * Decompiled with CFR 0.152.
 */
package adams.core.discovery.genetic;

import adams.core.discovery.PropertyPath;
import adams.core.discovery.genetic.AbstractGeneticDoubleMatrixDiscoveryHandler;
import adams.opt.genetic.AbstractGeneticAlgorithm;
import adams.opt.genetic.Hermione;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;
import weka.filters.supervised.attribute.PLSFilterWithLoadings;
import weka.filters.supervised.attribute.SIMPLSMatrixFilter;

public class SIMPLSWeightsMatrix
extends AbstractGeneticDoubleMatrixDiscoveryHandler {
    private static final long serialVersionUID = 6077250097532777489L;

    public String globalInfo() {
        return "Set the weights matrix .";
    }

    @Override
    protected int getDefaultSplits() {
        return 255;
    }

    @Override
    protected int getDefaultRows() {
        return 1701;
    }

    @Override
    protected int getDefaultColumns() {
        return 20;
    }

    @Override
    protected double getDefaultMinimum() {
        return -1.0;
    }

    @Override
    protected double getDefaultMaximum() {
        return 1.0;
    }

    @Override
    protected Matrix getValue(PropertyPath.PropertyContainer cont) {
        return ((SIMPLSMatrixFilter)((Object)cont.getObject())).getMatrix();
    }

    @Override
    protected void setValue(PropertyPath.PropertyContainer cont, Matrix value) {
        ((SIMPLSMatrixFilter)((Object)cont.getObject())).setMatrix(value);
    }

    public boolean requiresInitialization() {
        return true;
    }

    public void performInitialization(AbstractGeneticAlgorithm owner, PropertyPath.PropertyContainer cont) {
        PLSFilterWithLoadings pls = new PLSFilterWithLoadings();
        pls.setNumComponents(this.getColumns());
        pls.setAlgorithm(new SelectedTag(1, PLSFilter.TAGS_PREPROCESSING));
        pls.setAlgorithm(new SelectedTag(1, PLSFilter.TAGS_ALGORITHM));
        try {
            pls.setInputFormat(((Hermione)owner).getInstances());
            Filter.useFilter((Instances)((Hermione)owner).getInstances(), (Filter)pls);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Matrix value = pls.getSimplsW();
        ((SIMPLSMatrixFilter)((Object)cont.getObject())).setMatrix(value);
    }

    protected boolean handles(Object obj) {
        return obj instanceof PLSFilter;
    }
}

