/*
 * Decompiled with CFR 0.152.
 */
package adams.core.discovery.genetic;

import adams.core.discovery.genetic.GeneticHelper;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import weka.core.matrix.Matrix;

public class WekaGeneticHelper
extends GeneticHelper {
    private static Logger LOGGER = LoggingHelper.getLogger(WekaGeneticHelper.class);

    public static String matrixToBits(Matrix ina, double min, double max, int numBits, int splits, int rows, int columns) {
        StringBuilder buff = new StringBuilder();
        if (rows != ina.getRowDimension()) {
            LOGGER.warning("[matrixToBits] rows parameter differs from rows in matrix: " + rows + " != " + ina.getRowDimension());
        }
        if (columns != ina.getColumnDimension()) {
            LOGGER.warning("[matrixToBits] columns parameter differs from columns in matrix: " + columns + " != " + ina.getColumnDimension());
        }
        for (int row = 0; row < ina.getRowDimension(); ++row) {
            for (int column = 0; column < ina.getColumnDimension(); ++column) {
                double val = ina.get(row, column);
                buff.append(WekaGeneticHelper.doubleToBits((double)val, (double)min, (double)max, (int)numBits, (int)splits));
            }
        }
        return buff.toString();
    }

    public static Matrix bitsToMatrix(String bits, double min, double max, int numBits, int splits, int rows, int columns) {
        Matrix m = new Matrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                int start = row * columns * numBits + column * numBits;
                double j = 0.0;
                for (int i = start; i < start + numBits; ++i) {
                    if (bits.charAt(i) != '1') continue;
                    j += Math.pow(2.0, start + numBits - i - 1);
                }
                j = Math.min(j, (double)splits);
                double val = min + j * ((max - min) / (double)(splits - 1));
                m.set(row, column, val);
            }
        }
        return m;
    }
}

