/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.option.OptionUtils;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import weka.core.Capabilities;

public class WekaCapabilitiesToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -2595383708535316457L;

    public String globalInfo() {
        return "Turns a " + Capabilities.class.getName() + " object into a spreadsheet, listing all individual capabilities and whether they are supported.";
    }

    public Class accepts() {
        return Capabilities.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        Capabilities caps = (Capabilities)this.m_Input;
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        result.setName(OptionUtils.getCommandLine((Object)caps.getOwner()));
        HeaderRow row = result.getHeaderRow();
        row.addCell("K").setContent("Capability");
        row.addCell("S").setContent("Supported");
        row.addCell("D").setContent("Dependency");
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            row = result.addRow();
            row.addCell("K").setContentAsString(cap.toString());
            row.addCell("S").setContent(Boolean.valueOf(caps.handles(cap)));
            row.addCell("D").setContent(Boolean.valueOf(caps.hasDependency(cap)));
        }
        row = result.addRow();
        row.addCell("K").setContentAsString("Minimum # Instances ");
        row.addCell("S").setContent(Integer.valueOf(caps.getMinimumNumberInstances()));
        return result;
    }
}

