/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.util.logging.Level;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;

public abstract class AbstractWekaSpreadSheetReader
extends AbstractSpreadSheetReader {
    private static final long serialVersionUID = -8635190668122194492L;
    protected AbstractFileLoader m_Loader;

    protected void initialize() {
        super.initialize();
        this.m_Loader = this.newLoader();
    }

    protected abstract AbstractFileLoader newLoader();

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.FILE;
    }

    public String getFormatDescription() {
        return this.m_Loader.getFileDescription();
    }

    public String[] getFormatExtensions() {
        return this.m_Loader.getFileExtensions();
    }

    protected SpreadSheet doRead(File file) {
        SpreadSheet result = null;
        try {
            this.m_Loader.setFile(new File(file.getAbsolutePath()));
            this.m_Loader.reset();
            Instances data = this.m_Loader.getDataSet();
            this.m_Loader.reset();
            WekaInstancesToSpreadSheet convert = new WekaInstancesToSpreadSheet();
            convert.setSpreadSheetType(this.m_SpreadSheetType);
            convert.setInput(data);
            String msg = convert.convert();
            if (msg == null) {
                result = (SpreadSheet)convert.getOutput();
            } else {
                this.getLogger().severe("Failed to convert WEKA Instances into spreadsheet:\n" + msg);
            }
            convert.cleanUp();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load dataset: " + file, (Throwable)e);
            result = null;
        }
        return result;
    }
}

