/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.instance.Instance;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.input.IncrementalDataContainerReader;
import java.util.logging.Level;
import weka.core.Instances;
import weka.core.converters.ArffLoader;
import weka.core.converters.CSVLoader;
import weka.core.converters.ConverterUtils;

public class InstanceReader
extends AbstractDataContainerReader<Instance>
implements IncrementalDataContainerReader {
    private static final long serialVersionUID = 2653822253818697195L;
    protected ConverterUtils.DataSource m_Source;
    protected Instances m_Structure;
    protected int m_Index;

    public String globalInfo() {
        return "Reads WEKA datasets in various formats.";
    }

    public String getFormatDescription() {
        return "WEKA datasets";
    }

    public String[] getFormatExtensions() {
        return new String[]{ArffLoader.FILE_EXTENSION, ArffLoader.FILE_EXTENSION_COMPRESSED, CSVLoader.FILE_EXTENSION, CSVLoader.FILE_EXTENSION_COMPRESSED};
    }

    public void reset() {
        super.reset();
        this.m_Source = null;
        this.m_Structure = null;
        this.m_Index = 0;
    }

    protected void readData() {
        if (this.m_Source == null) {
            try {
                this.m_Index = 0;
                this.m_Source = new ConverterUtils.DataSource(this.getInput().getAbsolutePath());
                this.m_Structure = this.m_Source.getStructure();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error reading '" + this.getInput() + "':", (Throwable)e);
                this.m_Source = null;
                this.m_Structure = null;
            }
        }
        if (this.m_Source != null) {
            ++this.m_Index;
            Instance cont = new Instance();
            cont.set(this.m_Source.nextElement(this.m_Structure));
            cont.setID(this.m_Index + "." + this.m_Structure.relationName());
            this.m_ReadData.add(cont);
        }
    }

    public boolean hasMoreData() {
        return this.m_Source != null && this.m_Source.hasMoreElements(this.m_Structure);
    }
}

