/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.Iterator;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class WekaEvaluationContainer
extends AbstractContainer {
    private static final long serialVersionUID = -4976094375833503035L;
    public static final String VALUE_EVALUATION = "Evaluation";
    public static final String VALUE_MODEL = "Model";
    public static final String VALUE_PREDICTIONOUTPUT = "Prediction output";
    public static final String VALUE_ORIGINALINDICES = "Original indices";
    public static final String VALUE_TESTDATA = "Test data";

    public WekaEvaluationContainer() {
        this(null);
    }

    public WekaEvaluationContainer(Evaluation eval) {
        this(eval, null);
    }

    public WekaEvaluationContainer(Evaluation eval, Object model) {
        this(eval, model, null);
    }

    public WekaEvaluationContainer(Evaluation eval, Object model, String predOutput) {
        this(eval, model, predOutput, null);
    }

    public WekaEvaluationContainer(Evaluation eval, Object model, String predOutput, int[] originalIndices) {
        this.store(VALUE_EVALUATION, eval);
        this.store(VALUE_MODEL, model);
        this.store(VALUE_PREDICTIONOUTPUT, predOutput);
        this.store(VALUE_ORIGINALINDICES, originalIndices);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_EVALUATION, "evaluation object", Evaluation.class);
        this.addHelp(VALUE_MODEL, "model object", Object.class);
        this.addHelp(VALUE_PREDICTIONOUTPUT, "prediction output text", String.class);
        this.addHelp(VALUE_ORIGINALINDICES, "original indices (0-based); array of " + Integer.TYPE.getName());
        this.addHelp(VALUE_TESTDATA, "data used for testing", Instances.class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_EVALUATION);
        result.add(VALUE_MODEL);
        result.add(VALUE_PREDICTIONOUTPUT);
        result.add(VALUE_ORIGINALINDICES);
        result.add(VALUE_TESTDATA);
        return result.iterator();
    }

    public boolean isValid() {
        return this.hasValue(VALUE_EVALUATION);
    }
}

