/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.DataInfoActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Classifier;
import weka.clusterers.Clusterer;
import weka.core.Drawable;

public class WekaClustererInfo
extends AbstractTransformer
implements DataInfoActor {
    private static final long serialVersionUID = -3019442578354930841L;
    protected InfoType m_Type;

    public String globalInfo() {
        return "Outputs information of a trained weka.clusterers.Clusterer object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.MODEL);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public Class[] accepts() {
        return new Class[]{Classifier.class, WekaModelContainer.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case MODEL: 
            case GRAPH: {
                return new Class[]{String.class};
            }
            case NUM_CLUSTERS: {
                return new Class[]{Integer.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    protected String doExecute() {
        String result = null;
        Clusterer cls = null;
        if (this.m_InputToken.getPayload() instanceof Classifier) {
            cls = (Clusterer)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof WekaModelContainer) {
            cls = (Clusterer)((WekaModelContainer)((Object)this.m_InputToken.getPayload())).getValue("Model");
        } else {
            result = "Unhandled class: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (result == null) {
            switch (this.m_Type) {
                case MODEL: {
                    this.m_OutputToken = new Token((Object)cls.toString());
                    break;
                }
                case NUM_CLUSTERS: {
                    try {
                        this.m_OutputToken = new Token((Object)cls.numberOfClusters());
                    }
                    catch (Exception e) {
                        result = this.handleException("Failed to obtain number of clusters!", e);
                    }
                    break;
                }
                case GRAPH: {
                    try {
                        if (!(cls instanceof Drawable)) break;
                        this.m_OutputToken = new Token((Object)((Drawable)cls).graph());
                    }
                    catch (Exception e) {
                        result = this.handleException("Failed to obtain graph from clusterer!", e);
                    }
                    break;
                }
                default: {
                    result = "Unhandled info type: " + (Object)((Object)this.m_Type);
                }
            }
        }
        return result;
    }

    public static enum InfoType {
        MODEL,
        NUM_CLUSTERS,
        GRAPH;

    }
}

