/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.instancesanalysis.pls.AbstractPLS;
import adams.data.instancesanalysis.pls.MatrixHelper;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Classifier;
import weka.core.GenericPLSMatrixAccess;
import weka.filters.Filter;

public class WekaGenericPLSMatrixAccess
extends AbstractTransformer {
    private static final long serialVersionUID = -7107032132240547550L;
    protected String m_Matrix;

    public String globalInfo() {
        return "Transformer that allows the extraction of internal PLS filter/classifier matrices, forwarding them as spreadsheets.\nSee the respective PLS implementation for details on available matrix names (derived from: " + AbstractPLS.class.getName() + ")";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("matrix", "matrix", (Object)"P");
    }

    public void setMatrix(String value) {
        this.m_Matrix = value;
        this.reset();
    }

    public String getMatrix() {
        return this.m_Matrix;
    }

    public String matrixTipText() {
        return "The name of matrix to extract.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"matrix", (Object)this.m_Matrix, (String)"matrix: ");
    }

    public Class[] accepts() {
        return new Class[]{Classifier.class, Filter.class, GenericPLSMatrixAccess.class, WekaModelContainer.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected SpreadSheet getMatrix(Classifier classifier) {
        if (classifier instanceof GenericPLSMatrixAccess) {
            return this.getMatrix((GenericPLSMatrixAccess)classifier);
        }
        return null;
    }

    protected SpreadSheet getMatrix(GenericPLSMatrixAccess obj) {
        return MatrixHelper.matrixToSpreadSheet(obj.getMatrix(this.m_Matrix), this.m_Matrix);
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = null;
        if (this.m_InputToken.getPayload() instanceof GenericPLSMatrixAccess) {
            sheet = this.getMatrix((GenericPLSMatrixAccess)this.m_InputToken.getPayload());
        } else if (this.m_InputToken.getPayload() instanceof WekaModelContainer) {
            sheet = this.getMatrix((Classifier)((WekaModelContainer)((Object)this.m_InputToken.getPayload())).getValue("Model"));
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("sheet: " + sheet);
        }
        if (sheet != null) {
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

