/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.transformer.AbstractWekaModelReader;
import weka.classifiers.Classifier;
import weka.classifiers.ThreadSafeClassifier;
import weka.classifiers.meta.ThreadSafeClassifierWrapper;

public class WekaModelReader
extends AbstractWekaModelReader {
    private static final long serialVersionUID = -1844897560777043045L;
    protected boolean m_MakeThreadSafe;

    public String globalInfo() {
        return "Actor for loading a model (classifier or clusterer).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("make-thread-safe", "makeThreadSafe", (Object)false);
    }

    public void setMakeThreadSafe(boolean value) {
        this.m_MakeThreadSafe = value;
        this.reset();
    }

    public boolean getMakeThreadSafe() {
        return this.m_MakeThreadSafe;
    }

    public String makeThreadSafeTipText() {
        return "If enabled, the classifier model gets wrapped in a " + ThreadSafeClassifierWrapper.class.getName() + " meta-classifier.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"makeThreadSafe", (boolean)this.m_MakeThreadSafe, (String)"thread-safe", (String)"");
        if (value != null) {
            result = result.isEmpty() ? value : result + ", " + value;
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = super.doExecute();
        if (result == null && this.m_MakeThreadSafe) {
            if (this.m_OutputOnlyModel) {
                if (!(this.m_OutputToken.getPayload() instanceof ThreadSafeClassifier)) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Wrapping classifier");
                    }
                    ThreadSafeClassifierWrapper wrapper = new ThreadSafeClassifierWrapper();
                    wrapper.setClassifier((Classifier)this.m_OutputToken.getPayload());
                    this.m_OutputToken.setPayload((Object)wrapper);
                }
            } else {
                WekaModelContainer cont = (WekaModelContainer)((Object)this.m_OutputToken.getPayload());
                if (!(cont.getValue("Model") instanceof ThreadSafeClassifier)) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Wrapping classifier (in container)");
                    }
                    ThreadSafeClassifierWrapper wrapper = new ThreadSafeClassifierWrapper();
                    wrapper.setClassifier((Classifier)cont.getValue("Model"));
                    cont.setValue("Model", wrapper);
                    this.m_OutputToken.setPayload((Object)cont);
                }
            }
        }
        return result;
    }
}

