/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaclusterer;

import adams.data.statistics.StatUtils;
import adams.flow.transformer.wekaclusterer.AbstractClusterMembershipPostProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import weka.clusterers.Clusterer;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public class ClusterStatistics
extends AbstractClusterMembershipPostProcessor {
    private static final long serialVersionUID = 5983792992620091051L;

    public String globalInfo() {
        return "Computes cluster statistics (min/max/mean/stdev) for the provided dataset. An additional attribute is added to the dataset structure that indicates the cluster index and the statistic.\nOnly numeric attributes are considered when computing the statistics.\nStored in container under: Clustered dataset";
    }

    protected Instances createOutputFormat(Instances data) {
        Instances result = new Instances(data, 0);
        try {
            Add add = new Add();
            add.setAttributeIndex("1");
            add.setAttributeName("Statistic");
            add.setAttributeType(new SelectedTag(2, Add.TAGS_TYPE));
            add.setInputFormat(result);
            result = Filter.useFilter((Instances)result, (Filter)add);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    protected DenseInstance createRow(int index, String statistic, Instances data) {
        DenseInstance result = new DenseInstance(data.numAttributes());
        result.setDataset(data);
        result.setValue(0, (double)result.attribute(0).addStringValue(index + "-" + statistic));
        return result;
    }

    protected Instances calculateStatistics(Instances data, Clusterer clusterer, Instances outputFormat) {
        int i;
        Instances result = new Instances(outputFormat, 0);
        Hashtable<Integer, Instances> clusters = new Hashtable<Integer, Instances>();
        boolean error = false;
        String errorMsg = null;
        for (i = 0; i < data.numInstances(); ++i) {
            try {
                int cluster = clusterer.clusterInstance(data.instance(i));
                if (!clusters.containsKey(cluster)) {
                    clusters.put(cluster, new Instances(data, 0));
                }
                ((Instances)clusters.get(cluster)).add(data.instance(i));
                continue;
            }
            catch (Exception e) {
                if (error) continue;
                error = true;
                errorMsg = e.toString();
            }
        }
        if (!error) {
            ArrayList indices = new ArrayList(clusters.keySet());
            Collections.sort(indices);
            for (Integer cl : indices) {
                Instances subset = (Instances)clusters.get(cl);
                DenseInstance min = this.createRow(cl, "Min", result);
                DenseInstance max = this.createRow(cl, "Max", result);
                DenseInstance median = this.createRow(cl, "Median", result);
                DenseInstance mean = this.createRow(cl, "Mean", result);
                DenseInstance stdev = this.createRow(cl, "StdDev", result);
                for (i = 0; i < subset.numAttributes(); ++i) {
                    if (!subset.attribute(i).isNumeric()) continue;
                    double[] values = subset.attributeToDoubleArray(i);
                    min.setValue(i + 1, StatUtils.min((double[])values));
                    max.setValue(i + 1, StatUtils.max((double[])values));
                    median.setValue(i + 1, StatUtils.mean((double[])values));
                    mean.setValue(i + 1, StatUtils.mean((double[])values));
                    stdev.setValue(i + 1, StatUtils.stddev((double[])values, (boolean)true));
                }
                result.add((Instance)min);
                result.add((Instance)max);
                result.add((Instance)median);
                result.add((Instance)mean);
                result.add((Instance)stdev);
            }
        } else {
            this.getLogger().severe("At least one error occurred: " + errorMsg);
        }
        return result;
    }

    @Override
    protected Instances processDatasetWithClusterer(Instances data, Clusterer clusterer) {
        Instances result = this.createOutputFormat(data);
        result = this.calculateStatistics(data, clusterer, result);
        return result;
    }
}

