/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.GUIHelper;
import adams.gui.goe.PersistentObjectHistory;
import adams.gui.goe.WekaGenericObjectEditorDialog;
import adams.gui.goe.WekaGenericObjectEditorPopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import weka.gui.GenericObjectEditor;

public class WekaGenericObjectEditorPanel
extends AbstractChooserPanel {
    private static final long serialVersionUID = -8351558686664299781L;
    protected GenericObjectEditor m_Editor;
    protected WekaGenericObjectEditorDialog m_Dialog;
    protected PersistentObjectHistory m_History;
    protected transient Object m_Current;

    public WekaGenericObjectEditorPanel(Class cls, Object defValue) {
        this(cls, defValue, false);
    }

    public WekaGenericObjectEditorPanel(Class cls, Object defValue, boolean canChangeClassInDialog) {
        this.m_Editor = new GenericObjectEditor(canChangeClassInDialog);
        this.m_Editor.setClassType(cls);
        ((GenericObjectEditor.GOEPanel)this.m_Editor.getCustomEditor()).addOkListener(e -> {
            this.setCurrent(this.m_Editor.getValue());
            this.m_History.add(this.m_Editor.getValue());
            this.notifyChangeListeners(new ChangeEvent(this.m_Self));
        });
        ((GenericObjectEditor.GOEPanel)this.m_Editor.getCustomEditor()).addCancelListener(e -> this.m_Editor.setValue(this.getCurrent()));
        this.setCurrent(defValue);
        this.m_History = new PersistentObjectHistory();
        this.m_History.setSuperclass(cls);
    }

    protected void initialize() {
        super.initialize();
        this.m_Editor = null;
        this.m_Current = null;
    }

    protected Object doChoose() {
        if (this.m_Current != null) {
            this.m_Editor.setValue(this.m_Current);
        }
        if (this.m_Dialog == null) {
            this.m_Dialog = WekaGenericObjectEditorDialog.createDialog((Container)((Object)this), (PropertyEditor)this.m_Editor);
        }
        this.m_Dialog.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)this)));
        this.m_Dialog.setVisible(true);
        if (this.m_Dialog.getResult() == 0) {
            return this.m_Editor.getValue();
        }
        return null;
    }

    protected Object fromString(String value) {
        try {
            return OptionUtils.forAnyCommandLine(Object.class, (String)value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getCurrent() {
        return Utils.deepCopy((Object)this.m_Current);
    }

    protected String toString(Object value) {
        return OptionUtils.getCommandLine((Object)value);
    }

    public boolean setCurrent(Object value) {
        boolean result = super.setCurrent(value);
        if (result) {
            this.m_Current = value;
            if (this.m_Current != null) {
                this.m_Editor.setValue(this.m_Current);
            }
        }
        return result;
    }

    protected BasePopupMenu getPopupMenu() {
        WekaGenericObjectEditorPopupMenu menu = new WekaGenericObjectEditorPopupMenu((PropertyEditor)this.m_Editor, (JComponent)this.m_Self);
        menu.addChangeListener(e -> {
            this.setCurrent(this.m_Editor.getValue());
            this.notifyChangeListeners(new ChangeEvent(this.m_Self));
        });
        JMenuItem item = new JMenuItem("Edit...", GUIHelper.getIcon((String)"properties.gif"));
        item.addActionListener(e -> this.choose());
        menu.insert(new JPopupMenu.Separator(), 0);
        menu.insert(item, 0);
        this.m_History.customizePopupMenu((JPopupMenu)((Object)menu), this.getCurrent(), e -> {
            this.setCurrent(e.getHistoryItem());
            this.notifyChangeListeners(new ChangeEvent(this.m_Self));
        });
        if (this.m_PopupMenuCustomizer != null) {
            this.m_PopupMenuCustomizer.customizePopupMenu((AbstractChooserPanel)this, (JPopupMenu)((Object)menu));
        }
        return menu;
    }
}

