/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.core.GUIHelper;
import adams.gui.menu.AbstractParameterHandlingWekaMenuItemDefinition;
import java.awt.Component;
import java.io.File;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.ConverterFileChooser;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;

public class ROC
extends AbstractParameterHandlingWekaMenuItemDefinition {
    private static final long serialVersionUID = -771667287275117680L;
    protected ConverterFileChooser m_FileChooser;

    public ROC() {
        this(null);
    }

    public ROC(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new ConverterFileChooser(new File(System.getProperty("user.dir")));
    }

    public void launch() {
        Instances result;
        File file;
        if (this.m_Parameters.length == 0) {
            int retVal = this.m_FileChooser.showOpenDialog(null);
            if (retVal != 0) {
                return;
            }
            file = this.m_FileChooser.getSelectedFile();
        } else {
            file = new PlaceholderFile(this.m_Parameters[0]).getAbsoluteFile();
            this.m_FileChooser.setSelectedFile(file);
        }
        try {
            result = this.m_FileChooser.getLoader().getDataSet();
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Error loading file '" + file + "':\n" + LoggingHelper.throwableToString((Throwable)e)));
            return;
        }
        result.setClassIndex(result.numAttributes() - 1);
        ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
        vmc.setROCString("(Area under ROC = " + Utils.doubleToString((double)ThresholdCurve.getROCArea((Instances)result), (int)4) + ")");
        vmc.setName(result.relationName());
        PlotData2D tempd = new PlotData2D(result);
        tempd.setPlotName(result.relationName());
        tempd.addInstanceNumberAttribute();
        boolean[] cp = new boolean[result.numInstances()];
        for (int n = 1; n < cp.length; ++n) {
            cp[n] = true;
        }
        try {
            tempd.setConnectPoints(cp);
            vmc.addPlot(tempd);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Error adding plot:\n" + LoggingHelper.throwableToString((Throwable)e)));
            return;
        }
        ChildFrame frame = this.createChildFrame((Component)vmc, GUIHelper.getDefaultDialogDimension());
        frame.setTitle(frame.getTitle() + " - " + file);
    }

    public String getTitle() {
        return "WEKA ROC";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    @Override
    public String getCategory() {
        return "Visualization";
    }
}

