/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.data;

import adams.core.base.BasePassword;
import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.data.spreadsheet.sql.Reader;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.SQLF;
import adams.gui.tools.wekainvestigator.data.AbstractDataContainer;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.logging.Level;
import weka.core.Instances;
import weka.experiment.InstanceQuery;

public class DatabaseContainer
extends AbstractDataContainer {
    private static final long serialVersionUID = 6267905940957451551L;
    protected String m_URL;
    protected String m_Query;
    protected String m_User;
    protected String m_Password;

    public DatabaseContainer(String url, String user, String pw, String query) {
        try {
            DatabaseConnection conn = new DatabaseConnection(url, user, new BasePassword(pw));
            SQLF sql = SQLF.getSingleton((AbstractDatabaseConnection)conn);
            Reader reader = new Reader((AbstractTypeMapper)new DefaultTypeMapper(), DenseDataRow.class);
            ResultSet rs = sql.getResultSet(query);
            SpreadSheet sheet = reader.read(rs);
            SpreadSheetToWekaInstances conv = new SpreadSheetToWekaInstances();
            conv.setInput(sheet);
            String msg = conv.convert();
            if (msg != null) {
                throw new IllegalStateException(msg);
            }
            this.m_Data = (Instances)conv.getOutput(Instances.class);
            this.m_URL = url;
            this.m_Query = query;
            this.m_User = user;
            this.m_Password = pw;
            conv.cleanUp();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load data from DB: " + url, e);
        }
    }

    @Override
    public String getSource() {
        if (this.m_URL == null) {
            return "<unknown>";
        }
        return this.m_User + ":" + this.m_Password.replaceAll(".", "*") + "@" + this.m_URL + " using " + this.m_Query;
    }

    @Override
    public boolean canReload() {
        return this.m_URL != null;
    }

    @Override
    protected boolean doReload() {
        try {
            InstanceQuery instq = new InstanceQuery();
            instq.setDatabaseURL(this.m_URL);
            instq.setUsername(this.m_User);
            instq.setPassword(this.m_Password);
            instq.setQuery(this.m_Query);
            this.m_Data = instq.retrieveInstances();
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to reload from database: " + this.m_URL, (Throwable)e);
            return false;
        }
    }

    @Override
    protected Serializable[] getUndoData() {
        return new Serializable[]{this.m_Data, Boolean.valueOf(this.m_Modified), this.m_URL, this.m_User, this.m_Password, this.m_Query};
    }

    @Override
    protected void applyUndoData(Serializable[] data) {
        this.m_Data = (Instances)data[0];
        this.m_Modified = (Boolean)data[1];
        this.m_URL = (String)((Object)data[2]);
        this.m_User = (String)((Object)data[3]);
        this.m_Password = (String)((Object)data[4]);
        this.m_Query = (String)((Object)data[5]);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_URL = null;
        this.m_User = null;
        this.m_Password = null;
        this.m_Query = null;
    }
}

