/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.flow.core.Token;
import adams.flow.transformer.WekaInstancesMerge;
import adams.flow.transformer.WekaMergeInstancesActor;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import weka.core.Instances;

public class Merge
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Merge() {
        this.setName("Merge");
        this.setIcon("merge.png");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        WekaMergeInstancesActor merge = new WekaInstancesMerge();
        GenericObjectEditorDialog dialog = this.getOwner().getParentDialog() != null ? new GenericObjectEditorDialog(this.getOwner().getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getOwner().getParentFrame(), true);
        dialog.setTitle("Configure merge");
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(WekaMergeInstancesActor.class);
        dialog.setCurrent((Object)merge);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this.getOwner()));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            dialog.dispose();
            this.logMessage("Merge cancelled!");
            return;
        }
        merge = (WekaMergeInstancesActor)dialog.getCurrent();
        dialog.dispose();
        DataContainer[] conts = this.getSelectedData();
        Instances[] data = new Instances[conts.length];
        String msg = "";
        for (int i = 0; i < conts.length; ++i) {
            if (i > 0) {
                msg = msg + ", ";
            }
            data[i] = conts[i].getData();
            msg = msg + conts[i].getID() + "/" + conts[i].getData().relationName();
        }
        this.logMessage("Merging: " + msg);
        Token token = new Token((Object)data);
        msg = merge.setUp();
        if (msg == null) {
            merge.input(token);
            msg = merge.execute();
            if (msg == null) {
                token = merge.output();
                MemoryContainer cont = new MemoryContainer((Instances)token.getPayload());
                this.getData().add(cont);
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 2, this.getData().size() - 1));
            }
        }
        merge.destroy();
        if (msg != null) {
            this.logError(msg, "Failed to merge datasets");
        } else {
            this.logMessage("Merge successful!");
        }
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() > 1);
    }
}

