/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.flow.container.WekaTrainTestSetContainer;
import adams.gui.core.GUIHelper;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import weka.classifiers.DefaultRandomSplitGenerator;
import weka.classifiers.RandomSplitGenerator;
import weka.core.Instances;

public class Split
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;
    protected RandomSplitGenerator m_LastSplitter;

    public Split() {
        this.setName("Split");
        this.setIcon("percentage.gif");
        this.setAsynchronous(true);
        this.m_LastSplitter = new DefaultRandomSplitGenerator();
    }

    protected void doActionPerformed(ActionEvent e) {
        GenericObjectEditorDialog dialog = GUIHelper.getParentDialog((Container)((Object)this.getOwner())) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)((Object)this.getOwner())), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)((Object)this.getOwner())), true);
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(RandomSplitGenerator.class);
        dialog.setCurrent((Object)this.m_LastSplitter);
        dialog.setTitle("Split");
        dialog.setLocationRelativeTo((Component)((Object)this.getOwner().getOwner()));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        RandomSplitGenerator splitter = (RandomSplitGenerator)dialog.getCurrent();
        this.m_LastSplitter = (RandomSplitGenerator)dialog.getCurrent();
        DataContainer cont = this.getSelectedData()[0];
        this.logMessage("Splitting dataset: " + cont.getID() + "/" + cont.getData().relationName() + " [" + cont.getSource() + "]");
        splitter.setData(cont.getData());
        WekaTrainTestSetContainer ttcont = splitter.next();
        MemoryContainer trainCont = new MemoryContainer((Instances)ttcont.getValue("Train"));
        trainCont.getData().setRelationName(cont.getData().relationName() + "-train");
        MemoryContainer testCont = new MemoryContainer((Instances)ttcont.getValue("Test"));
        testCont.getData().setRelationName(cont.getData().relationName() + "-test");
        this.getData().add(trainCont);
        this.getData().add(testCont);
        this.logMessage("Successfully split " + cont.getID() + " into " + trainCont.getID() + " and " + testCont.getID() + "!");
        this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 2, new int[]{this.getData().size() - 2, this.getData().size() - 1}));
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1);
    }
}

