/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.clustertab.output;

import adams.core.MessageCollection;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetTable;
import adams.gui.tools.wekainvestigator.output.TableContentPanel;
import adams.gui.tools.wekainvestigator.tab.clustertab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.output.AbstractOutputGenerator;
import javax.swing.JComponent;

public class ClusterAssignments
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;

    public String globalInfo() {
        return "Outputs the cluster assignments.";
    }

    @Override
    public String getTitle() {
        return "Cluster assignments";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().getClusterAssignments() != null;
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        DefaultSpreadSheet sheet = new DefaultSpreadSheet();
        sheet.getHeaderRow().addCell("A").setContent("Assignment");
        for (double assignment : item.getEvaluation().getClusterAssignments()) {
            sheet.addRow().addCell("A").setContent(Double.valueOf(assignment));
        }
        SpreadSheetTable table = new SpreadSheetTable((SpreadSheet)sheet);
        return new TableContentPanel((SortableAndSearchableTable)table, true, true);
    }
}

