/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances;

import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SearchPanel;
import adams.gui.visualization.instances.InstancesColumnComboBox;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.InstancesTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import weka.core.Instances;

public class InstancesPanel
extends BasePanel {
    private static final long serialVersionUID = -6517998516164369299L;
    protected InstancesTable m_Table;
    protected SearchPanel m_PanelSearch;
    protected InstancesColumnComboBox m_ColumnComboBox;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Table = new InstancesTable(new InstancesTableModel());
        this.add((Component)new BaseScrollPane((Component)((Object)this.m_Table)), "Center");
        JPanel panel = new JPanel(new FlowLayout(2));
        this.m_ColumnComboBox = new InstancesColumnComboBox(this.m_Table);
        JLabel label = new JLabel("Jump to");
        label.setLabelFor((Component)((Object)this.m_ColumnComboBox));
        label.setDisplayedMnemonic('J');
        panel.add(label);
        panel.add((Component)((Object)this.m_ColumnComboBox));
        this.add(panel, "North");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(e -> this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
        this.add((Component)this.m_PanelSearch, "South");
    }

    public InstancesTable getTable() {
        return this.m_Table;
    }

    public SearchPanel getSearchPanel() {
        return this.m_PanelSearch;
    }

    public void setInstances(Instances value) {
        this.m_Table.setInstances(value);
        this.m_ColumnComboBox.update();
    }

    public Instances getInstances() {
        return this.m_Table.getInstances();
    }

    public synchronized void setModel(TableModel model) {
        this.m_Table.setModel(model);
        this.update();
    }

    public TableModel getModel() {
        return this.m_Table.getModel();
    }

    public void update() {
        this.m_ColumnComboBox.update();
    }
}

