/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Statistics;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.matrix.LUDecomposition;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class GaussianProcessesWeighted
extends AbstractClassifier
implements WeightedInstancesHandler,
OptionHandler,
IntervalEstimator,
TechnicalInformationHandler {
    static final long serialVersionUID = -8620066949967678545L;
    protected NominalToBinary m_NominalToBinary;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_checksTurnedOff = true;
    protected double m_delta = 1.0;
    protected int m_classIndex = -1;
    protected double m_Alin;
    protected double m_Blin;
    protected Kernel m_kernel = new RBFKernel();
    protected int m_NumTrain = 0;
    protected double m_avg_target;
    protected Matrix m_C;
    protected Matrix m_t;
    protected boolean m_KernelIsLinear = false;

    public GaussianProcessesWeighted() {
        ((RBFKernel)this.m_kernel).setGamma(1.0);
    }

    public String globalInfo() {
        return "Implements Gaussian Processes for regression without hyperparameter-tuning. For more information see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "David J.C. Mackay");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Introduction to Gaussian Processes");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Dept. of Physics, Cambridge University, UK");
        result.setValue(TechnicalInformation.Field.PS, "http://wol.ra.phy.cam.ac.uk/mackay/gpB.ps.gz");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.getKernel().getCapabilities();
        result.setOwner((CapabilitiesHandler)this);
        result.enableAllAttributeDependencies();
        if (result.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.disable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances insts) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(insts);
            insts = new Instances(insts);
            insts.deleteWithMissingClass();
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean onlyNumeric = true;
            if (!this.m_checksTurnedOff) {
                for (int i = 0; i < insts.numAttributes(); ++i) {
                    if (i == insts.classIndex() || insts.attribute(i).isNumeric()) continue;
                    onlyNumeric = false;
                    break;
                }
            }
            if (!onlyNumeric) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(insts);
                insts = Filter.useFilter((Instances)insts, (Filter)this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        this.m_classIndex = insts.classIndex();
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_NumTrain = insts.numInstances();
        if (this.m_Filter != null) {
            Instance witness = (Instance)insts.instance(0).copy();
            witness.setValue(this.m_classIndex, 0.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            Instance res = this.m_Filter.output();
            this.m_Blin = res.value(this.m_classIndex);
            witness.setValue(this.m_classIndex, 1.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            res = this.m_Filter.output();
            this.m_Alin = res.value(this.m_classIndex) - this.m_Blin;
        } else {
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
        }
        this.m_kernel.buildKernel(insts);
        this.m_KernelIsLinear = this.m_kernel instanceof PolyKernel && ((PolyKernel)this.m_kernel).getExponent() == 1.0;
        this.m_C = new Matrix(insts.numInstances(), insts.numInstances());
        double sum = 0.0;
        for (int i = 0; i < insts.numInstances(); ++i) {
            sum += insts.instance(i).classValue();
            for (int j = 0; j < i; ++j) {
                double kv = this.m_kernel.eval(i, j, insts.instance(i));
                this.m_C.set(i, j, kv);
                this.m_C.set(j, i, kv);
            }
            double kv = this.m_kernel.eval(i, i, insts.instance(i));
            this.m_C.set(i, i, kv + this.m_delta * this.m_delta);
        }
        this.m_avg_target = sum / (double)insts.numInstances();
        LUDecomposition lu = new LUDecomposition(this.m_C);
        if (!lu.isNonsingular()) {
            throw new Exception("Singular Matrix?!?");
        }
        Matrix iMat = Matrix.identity((int)insts.numInstances(), (int)insts.numInstances());
        this.m_C = lu.solve(iMat);
        this.m_t = new Matrix(insts.numInstances(), 1);
        for (int i = 0; i < insts.numInstances(); ++i) {
            this.m_t.set(i, 0, insts.instance(i).classValue() - this.m_avg_target);
        }
        this.m_t = this.m_C.times(this.m_t);
    }

    public double classifyInstance(Instance inst) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        Matrix k = new Matrix(this.m_NumTrain, 1);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
        }
        double result = k.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        return result;
    }

    public double[][] predictIntervals(Instance inst, double confidenceLevel) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        Matrix k = new Matrix(this.m_NumTrain, 1);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
        }
        double kappa = this.m_kernel.eval(-1, -1, inst) + this.m_delta * this.m_delta;
        double estimate = k.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        double sigma = Math.sqrt(kappa - k.transpose().times(this.m_C).times(k).get(0, 0));
        confidenceLevel = 1.0 - (1.0 - confidenceLevel) / 2.0;
        double z = Statistics.normalInverse((double)confidenceLevel);
        double[][] interval = new double[1][2];
        interval[0][0] = estimate - z * sigma;
        interval[0][1] = estimate + z * sigma;
        return interval;
    }

    public double getStandardDeviation(Instance inst) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        Matrix k = new Matrix(this.m_NumTrain, 1);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
        }
        double kappa = this.m_kernel.eval(-1, -1, inst) + this.m_delta * this.m_delta;
        double var = kappa - k.transpose().times(this.m_C).times(k).get(0, 0);
        if (var < 0.0) {
            System.out.println("Aiaiai: variance is negative (" + var + ")!!!");
        }
        double sigma = Math.sqrt(var);
        return sigma;
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tLevel of Gaussian Noise.\n\t(default: 1.0)", "L", 1, "-L <double>"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default: 0=normalize)", "N", 1, "-N"));
        result.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        enm = this.getKernel().listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'L', (String[])options);
        if (tmpStr.length() != 0) {
            this.setNoise(Double.parseDouble(tmpStr));
        } else {
            this.setNoise(1.0);
        }
        tmpStr = Utils.getOption((char)'N', (String[])options);
        if (tmpStr.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(tmpStr), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        tmpStr = Utils.getOption((char)'K', (String[])options);
        String[] tmpOptions = Utils.splitOptions((String)tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setKernel(Kernel.forName((String)tmpStr, (String[])tmpOptions));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-L");
        result.add("" + this.getNoise());
        result.add("-N");
        result.add("" + this.m_filterType);
        result.add("-K");
        result.add("" + this.m_kernel.getClass().getName() + " " + Utils.joinOptions((String[])this.m_kernel.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public void setKernel(Kernel value) {
        this.m_kernel = value;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String noiseTipText() {
        return "The level of Gaussian Noise (added to the diagonal of the Covariance Matrix).";
    }

    public double getNoise() {
        return this.m_delta;
    }

    public void setNoise(double v) {
        this.m_delta = v;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_t == null) {
            return "Gaussian Processes: No model built yet.";
        }
        try {
            int i;
            text.append("Gaussian Processes\n\n");
            text.append("Kernel used:\n  " + this.m_kernel.toString() + "\n\n");
            text.append("Average Target Value : " + this.m_avg_target + "\n");
            text.append("Inverted Covariance Matrix:\n");
            double min = this.m_C.get(0, 0);
            double max = this.m_C.get(0, 0);
            for (i = 0; i < this.m_NumTrain; ++i) {
                for (int j = 0; j < this.m_NumTrain; ++j) {
                    if (this.m_C.get(i, j) < min) {
                        min = this.m_C.get(i, j);
                        continue;
                    }
                    if (!(this.m_C.get(i, j) > max)) continue;
                    max = this.m_C.get(i, j);
                }
            }
            text.append("    Lowest Value = " + min + "\n");
            text.append("    Highest Value = " + max + "\n");
            text.append("Inverted Covariance Matrix * Target-value Vector:\n");
            min = this.m_t.get(0, 0);
            max = this.m_t.get(0, 0);
            for (i = 0; i < this.m_NumTrain; ++i) {
                if (this.m_t.get(i, 0) < min) {
                    min = this.m_t.get(i, 0);
                    continue;
                }
                if (!(this.m_t.get(i, 0) > max)) continue;
                max = this.m_t.get(i, 0);
            }
            text.append("    Lowest Value = " + min + "\n");
            text.append("    Highest Value = " + max + "\n \n");
        }
        catch (Exception e) {
            return "Can't print the classifier.";
        }
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] argv) {
        GaussianProcessesWeighted.runClassifier((Classifier)new GaussianProcessesWeighted(), (String[])argv);
    }
}

